/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.loadbalancer.model.UpdateHealthCheckerDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateHealthCheckerRequest
extends BmcRequest {
    private UpdateHealthCheckerDetails healthChecker;
    private String loadBalancerId;
    private String backendSetName;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"healthChecker", "loadBalancerId", "backendSetName", "opcRequestId", "opcRetryToken"})
    UpdateHealthCheckerRequest(UpdateHealthCheckerDetails healthChecker, String loadBalancerId, String backendSetName, String opcRequestId, String opcRetryToken) {
        this.healthChecker = healthChecker;
        this.loadBalancerId = loadBalancerId;
        this.backendSetName = backendSetName;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateHealthCheckerDetails getHealthChecker() {
        return this.healthChecker;
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getBackendSetName() {
        return this.backendSetName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private UpdateHealthCheckerDetails healthChecker;
        private String loadBalancerId;
        private String backendSetName;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateHealthCheckerRequest o) {
            this.healthChecker(o.getHealthChecker());
            this.loadBalancerId(o.getLoadBalancerId());
            this.backendSetName(o.getBackendSetName());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateHealthCheckerRequest build() {
            UpdateHealthCheckerRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder healthChecker(UpdateHealthCheckerDetails healthChecker) {
            this.healthChecker = healthChecker;
            return this;
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder backendSetName(String backendSetName) {
            this.backendSetName = backendSetName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public UpdateHealthCheckerRequest buildWithoutInvocationCallback() {
            return new UpdateHealthCheckerRequest(this.healthChecker, this.loadBalancerId, this.backendSetName, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "UpdateHealthCheckerRequest.Builder(healthChecker=" + this.healthChecker + ", loadBalancerId=" + this.loadBalancerId + ", backendSetName=" + this.backendSetName + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

