/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.BackendHealth;
import java.beans.ConstructorProperties;

public class GetBackendHealthResponse {
    private String opcRequestId;
    private BackendHealth backendHealth;

    @ConstructorProperties(value={"opcRequestId", "backendHealth"})
    GetBackendHealthResponse(String opcRequestId, BackendHealth backendHealth) {
        this.opcRequestId = opcRequestId;
        this.backendHealth = backendHealth;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BackendHealth getBackendHealth() {
        return this.backendHealth;
    }

    public static class Builder {
        private String opcRequestId;
        private BackendHealth backendHealth;

        public Builder copy(GetBackendHealthResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.backendHealth(o.getBackendHealth());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder backendHealth(BackendHealth backendHealth) {
            this.backendHealth = backendHealth;
            return this;
        }

        public GetBackendHealthResponse build() {
            return new GetBackendHealthResponse(this.opcRequestId, this.backendHealth);
        }

        public String toString() {
            return "GetBackendHealthResponse.Builder(opcRequestId=" + this.opcRequestId + ", backendHealth=" + this.backendHealth + ")";
        }
    }
}

