/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.Backend;
import java.beans.ConstructorProperties;

public class GetBackendResponse {
    private String opcRequestId;
    private Backend backend;

    @ConstructorProperties(value={"opcRequestId", "backend"})
    GetBackendResponse(String opcRequestId, Backend backend) {
        this.opcRequestId = opcRequestId;
        this.backend = backend;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public static class Builder {
        private String opcRequestId;
        private Backend backend;

        public Builder copy(GetBackendResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.backend(o.getBackend());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder backend(Backend backend) {
            this.backend = backend;
            return this;
        }

        public GetBackendResponse build() {
            return new GetBackendResponse(this.opcRequestId, this.backend);
        }

        public String toString() {
            return "GetBackendResponse.Builder(opcRequestId=" + this.opcRequestId + ", backend=" + this.backend + ")";
        }
    }
}

