/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.BackendSetHealth;
import java.beans.ConstructorProperties;

public class GetBackendSetHealthResponse {
    private String opcRequestId;
    private BackendSetHealth backendSetHealth;

    @ConstructorProperties(value={"opcRequestId", "backendSetHealth"})
    GetBackendSetHealthResponse(String opcRequestId, BackendSetHealth backendSetHealth) {
        this.opcRequestId = opcRequestId;
        this.backendSetHealth = backendSetHealth;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BackendSetHealth getBackendSetHealth() {
        return this.backendSetHealth;
    }

    public static class Builder {
        private String opcRequestId;
        private BackendSetHealth backendSetHealth;

        public Builder copy(GetBackendSetHealthResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.backendSetHealth(o.getBackendSetHealth());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder backendSetHealth(BackendSetHealth backendSetHealth) {
            this.backendSetHealth = backendSetHealth;
            return this;
        }

        public GetBackendSetHealthResponse build() {
            return new GetBackendSetHealthResponse(this.opcRequestId, this.backendSetHealth);
        }

        public String toString() {
            return "GetBackendSetHealthResponse.Builder(opcRequestId=" + this.opcRequestId + ", backendSetHealth=" + this.backendSetHealth + ")";
        }
    }
}

