/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.BackendSet;
import java.beans.ConstructorProperties;

public class GetBackendSetResponse {
    private String opcRequestId;
    private BackendSet backendSet;

    @ConstructorProperties(value={"opcRequestId", "backendSet"})
    GetBackendSetResponse(String opcRequestId, BackendSet backendSet) {
        this.opcRequestId = opcRequestId;
        this.backendSet = backendSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BackendSet getBackendSet() {
        return this.backendSet;
    }

    public static class Builder {
        private String opcRequestId;
        private BackendSet backendSet;

        public Builder copy(GetBackendSetResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.backendSet(o.getBackendSet());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder backendSet(BackendSet backendSet) {
            this.backendSet = backendSet;
            return this;
        }

        public GetBackendSetResponse build() {
            return new GetBackendSetResponse(this.opcRequestId, this.backendSet);
        }

        public String toString() {
            return "GetBackendSetResponse.Builder(opcRequestId=" + this.opcRequestId + ", backendSet=" + this.backendSet + ")";
        }
    }
}

