/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.HealthChecker;
import java.beans.ConstructorProperties;

public class GetHealthCheckerResponse {
    private String opcRequestId;
    private HealthChecker healthChecker;

    @ConstructorProperties(value={"opcRequestId", "healthChecker"})
    GetHealthCheckerResponse(String opcRequestId, HealthChecker healthChecker) {
        this.opcRequestId = opcRequestId;
        this.healthChecker = healthChecker;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public HealthChecker getHealthChecker() {
        return this.healthChecker;
    }

    public static class Builder {
        private String opcRequestId;
        private HealthChecker healthChecker;

        public Builder copy(GetHealthCheckerResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.healthChecker(o.getHealthChecker());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder healthChecker(HealthChecker healthChecker) {
            this.healthChecker = healthChecker;
            return this;
        }

        public GetHealthCheckerResponse build() {
            return new GetHealthCheckerResponse(this.opcRequestId, this.healthChecker);
        }

        public String toString() {
            return "GetHealthCheckerResponse.Builder(opcRequestId=" + this.opcRequestId + ", healthChecker=" + this.healthChecker + ")";
        }
    }
}

