/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.Hostname;
import java.beans.ConstructorProperties;

public class GetHostnameResponse {
    private String opcRequestId;
    private Hostname hostname;

    @ConstructorProperties(value={"opcRequestId", "hostname"})
    GetHostnameResponse(String opcRequestId, Hostname hostname) {
        this.opcRequestId = opcRequestId;
        this.hostname = hostname;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Hostname getHostname() {
        return this.hostname;
    }

    public static class Builder {
        private String opcRequestId;
        private Hostname hostname;

        public Builder copy(GetHostnameResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.hostname(o.getHostname());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder hostname(Hostname hostname) {
            this.hostname = hostname;
            return this;
        }

        public GetHostnameResponse build() {
            return new GetHostnameResponse(this.opcRequestId, this.hostname);
        }

        public String toString() {
            return "GetHostnameResponse.Builder(opcRequestId=" + this.opcRequestId + ", hostname=" + this.hostname + ")";
        }
    }
}

