/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.LoadBalancerHealth;
import java.beans.ConstructorProperties;

public class GetLoadBalancerHealthResponse {
    private String opcRequestId;
    private LoadBalancerHealth loadBalancerHealth;

    @ConstructorProperties(value={"opcRequestId", "loadBalancerHealth"})
    GetLoadBalancerHealthResponse(String opcRequestId, LoadBalancerHealth loadBalancerHealth) {
        this.opcRequestId = opcRequestId;
        this.loadBalancerHealth = loadBalancerHealth;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public LoadBalancerHealth getLoadBalancerHealth() {
        return this.loadBalancerHealth;
    }

    public static class Builder {
        private String opcRequestId;
        private LoadBalancerHealth loadBalancerHealth;

        public Builder copy(GetLoadBalancerHealthResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.loadBalancerHealth(o.getLoadBalancerHealth());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder loadBalancerHealth(LoadBalancerHealth loadBalancerHealth) {
            this.loadBalancerHealth = loadBalancerHealth;
            return this;
        }

        public GetLoadBalancerHealthResponse build() {
            return new GetLoadBalancerHealthResponse(this.opcRequestId, this.loadBalancerHealth);
        }

        public String toString() {
            return "GetLoadBalancerHealthResponse.Builder(opcRequestId=" + this.opcRequestId + ", loadBalancerHealth=" + this.loadBalancerHealth + ")";
        }
    }
}

