/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.LoadBalancer;
import java.beans.ConstructorProperties;

public class GetLoadBalancerResponse {
    private String opcRequestId;
    private LoadBalancer loadBalancer;

    @ConstructorProperties(value={"opcRequestId", "loadBalancer"})
    GetLoadBalancerResponse(String opcRequestId, LoadBalancer loadBalancer) {
        this.opcRequestId = opcRequestId;
        this.loadBalancer = loadBalancer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public static class Builder {
        private String opcRequestId;
        private LoadBalancer loadBalancer;

        public Builder copy(GetLoadBalancerResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.loadBalancer(o.getLoadBalancer());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder loadBalancer(LoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public GetLoadBalancerResponse build() {
            return new GetLoadBalancerResponse(this.opcRequestId, this.loadBalancer);
        }

        public String toString() {
            return "GetLoadBalancerResponse.Builder(opcRequestId=" + this.opcRequestId + ", loadBalancer=" + this.loadBalancer + ")";
        }
    }
}

