/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.PathRouteSet;
import java.beans.ConstructorProperties;

public class GetPathRouteSetResponse {
    private String opcRequestId;
    private PathRouteSet pathRouteSet;

    @ConstructorProperties(value={"opcRequestId", "pathRouteSet"})
    GetPathRouteSetResponse(String opcRequestId, PathRouteSet pathRouteSet) {
        this.opcRequestId = opcRequestId;
        this.pathRouteSet = pathRouteSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PathRouteSet getPathRouteSet() {
        return this.pathRouteSet;
    }

    public static class Builder {
        private String opcRequestId;
        private PathRouteSet pathRouteSet;

        public Builder copy(GetPathRouteSetResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.pathRouteSet(o.getPathRouteSet());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder pathRouteSet(PathRouteSet pathRouteSet) {
            this.pathRouteSet = pathRouteSet;
            return this;
        }

        public GetPathRouteSetResponse build() {
            return new GetPathRouteSetResponse(this.opcRequestId, this.pathRouteSet);
        }

        public String toString() {
            return "GetPathRouteSetResponse.Builder(opcRequestId=" + this.opcRequestId + ", pathRouteSet=" + this.pathRouteSet + ")";
        }
    }
}

