/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.RuleSet;
import java.beans.ConstructorProperties;

public class GetRuleSetResponse {
    private String opcRequestId;
    private RuleSet ruleSet;

    @ConstructorProperties(value={"opcRequestId", "ruleSet"})
    GetRuleSetResponse(String opcRequestId, RuleSet ruleSet) {
        this.opcRequestId = opcRequestId;
        this.ruleSet = ruleSet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public static class Builder {
        private String opcRequestId;
        private RuleSet ruleSet;

        public Builder copy(GetRuleSetResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.ruleSet(o.getRuleSet());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ruleSet(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
            return this;
        }

        public GetRuleSetResponse build() {
            return new GetRuleSetResponse(this.opcRequestId, this.ruleSet);
        }

        public String toString() {
            return "GetRuleSetResponse.Builder(opcRequestId=" + this.opcRequestId + ", ruleSet=" + this.ruleSet + ")";
        }
    }
}

