/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.WorkRequest;
import java.beans.ConstructorProperties;

public class GetWorkRequestResponse {
    private String opcRequestId;
    private WorkRequest workRequest;

    @ConstructorProperties(value={"opcRequestId", "workRequest"})
    GetWorkRequestResponse(String opcRequestId, WorkRequest workRequest) {
        this.opcRequestId = opcRequestId;
        this.workRequest = workRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public WorkRequest getWorkRequest() {
        return this.workRequest;
    }

    public static class Builder {
        private String opcRequestId;
        private WorkRequest workRequest;

        public Builder copy(GetWorkRequestResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.workRequest(o.getWorkRequest());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder workRequest(WorkRequest workRequest) {
            this.workRequest = workRequest;
            return this;
        }

        public GetWorkRequestResponse build() {
            return new GetWorkRequestResponse(this.opcRequestId, this.workRequest);
        }

        public String toString() {
            return "GetWorkRequestResponse.Builder(opcRequestId=" + this.opcRequestId + ", workRequest=" + this.workRequest + ")";
        }
    }
}

