/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.BackendSet;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListBackendSetsResponse {
    private String opcRequestId;
    private List<BackendSet> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListBackendSetsResponse(String opcRequestId, List<BackendSet> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<BackendSet> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<BackendSet> items;

        public Builder copy(ListBackendSetsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<BackendSet> items) {
            this.items = items;
            return this;
        }

        public ListBackendSetsResponse build() {
            return new ListBackendSetsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListBackendSetsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

