/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.Backend;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListBackendsResponse {
    private String opcRequestId;
    private List<Backend> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListBackendsResponse(String opcRequestId, List<Backend> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Backend> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<Backend> items;

        public Builder copy(ListBackendsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Backend> items) {
            this.items = items;
            return this;
        }

        public ListBackendsResponse build() {
            return new ListBackendsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListBackendsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

