/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.Certificate;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListCertificatesResponse {
    private String opcRequestId;
    private List<Certificate> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListCertificatesResponse(String opcRequestId, List<Certificate> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Certificate> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<Certificate> items;

        public Builder copy(ListCertificatesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Certificate> items) {
            this.items = items;
            return this;
        }

        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListCertificatesResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

