/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.Hostname;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListHostnamesResponse {
    private String opcRequestId;
    private List<Hostname> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListHostnamesResponse(String opcRequestId, List<Hostname> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Hostname> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<Hostname> items;

        public Builder copy(ListHostnamesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Hostname> items) {
            this.items = items;
            return this;
        }

        public ListHostnamesResponse build() {
            return new ListHostnamesResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListHostnamesResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

