/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.ListenerRuleSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListListenerRulesResponse {
    private String opcRequestId;
    private List<ListenerRuleSummary> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListListenerRulesResponse(String opcRequestId, List<ListenerRuleSummary> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ListenerRuleSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<ListenerRuleSummary> items;

        public Builder copy(ListListenerRulesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<ListenerRuleSummary> items) {
            this.items = items;
            return this;
        }

        public ListListenerRulesResponse build() {
            return new ListListenerRulesResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListListenerRulesResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

