/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.LoadBalancerHealthSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListLoadBalancerHealthsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<LoadBalancerHealthSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListLoadBalancerHealthsResponse(String opcNextPage, String opcRequestId, List<LoadBalancerHealthSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<LoadBalancerHealthSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<LoadBalancerHealthSummary> items;

        public Builder copy(ListLoadBalancerHealthsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<LoadBalancerHealthSummary> items) {
            this.items = items;
            return this;
        }

        public ListLoadBalancerHealthsResponse build() {
            return new ListLoadBalancerHealthsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListLoadBalancerHealthsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

