/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.PathRouteSet;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListPathRouteSetsResponse {
    private String opcRequestId;
    private List<PathRouteSet> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListPathRouteSetsResponse(String opcRequestId, List<PathRouteSet> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<PathRouteSet> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<PathRouteSet> items;

        public Builder copy(ListPathRouteSetsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<PathRouteSet> items) {
            this.items = items;
            return this;
        }

        public ListPathRouteSetsResponse build() {
            return new ListPathRouteSetsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListPathRouteSetsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

