/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.LoadBalancerPolicy;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListPoliciesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<LoadBalancerPolicy> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListPoliciesResponse(String opcNextPage, String opcRequestId, List<LoadBalancerPolicy> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<LoadBalancerPolicy> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<LoadBalancerPolicy> items;

        public Builder copy(ListPoliciesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<LoadBalancerPolicy> items) {
            this.items = items;
            return this;
        }

        public ListPoliciesResponse build() {
            return new ListPoliciesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListPoliciesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

