/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.LoadBalancerProtocol;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListProtocolsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<LoadBalancerProtocol> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListProtocolsResponse(String opcNextPage, String opcRequestId, List<LoadBalancerProtocol> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<LoadBalancerProtocol> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<LoadBalancerProtocol> items;

        public Builder copy(ListProtocolsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<LoadBalancerProtocol> items) {
            this.items = items;
            return this;
        }

        public ListProtocolsResponse build() {
            return new ListProtocolsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListProtocolsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

