/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.responses;

import com.oracle.bmc.loadbalancer.model.RuleSet;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListRuleSetsResponse {
    private String opcRequestId;
    private List<RuleSet> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListRuleSetsResponse(String opcRequestId, List<RuleSet> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<RuleSet> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<RuleSet> items;

        public Builder copy(ListRuleSetsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<RuleSet> items) {
            this.items = items;
            return this;
        }

        public ListRuleSetsResponse build() {
            return new ListRuleSetsResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListRuleSetsResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

