/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.monitoring.MonitoringAsync;
import com.oracle.bmc.monitoring.internal.http.ChangeAlarmCompartmentConverter;
import com.oracle.bmc.monitoring.internal.http.CreateAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.DeleteAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.GetAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.GetAlarmHistoryConverter;
import com.oracle.bmc.monitoring.internal.http.ListAlarmsConverter;
import com.oracle.bmc.monitoring.internal.http.ListAlarmsStatusConverter;
import com.oracle.bmc.monitoring.internal.http.ListMetricsConverter;
import com.oracle.bmc.monitoring.internal.http.PostMetricDataConverter;
import com.oracle.bmc.monitoring.internal.http.RemoveAlarmSuppressionConverter;
import com.oracle.bmc.monitoring.internal.http.SummarizeMetricsDataConverter;
import com.oracle.bmc.monitoring.internal.http.UpdateAlarmConverter;
import com.oracle.bmc.monitoring.requests.ChangeAlarmCompartmentRequest;
import com.oracle.bmc.monitoring.requests.CreateAlarmRequest;
import com.oracle.bmc.monitoring.requests.DeleteAlarmRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmHistoryRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.requests.RemoveAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.SummarizeMetricsDataRequest;
import com.oracle.bmc.monitoring.requests.UpdateAlarmRequest;
import com.oracle.bmc.monitoring.responses.ChangeAlarmCompartmentResponse;
import com.oracle.bmc.monitoring.responses.CreateAlarmResponse;
import com.oracle.bmc.monitoring.responses.DeleteAlarmResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmHistoryResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import com.oracle.bmc.monitoring.responses.RemoveAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.SummarizeMetricsDataResponse;
import com.oracle.bmc.monitoring.responses.UpdateAlarmResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringAsyncClient
implements MonitoringAsync {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MONITORING").serviceEndpointPrefix("telemetry").serviceEndpointTemplate("https://telemetry.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public MonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public MonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public MonitoringAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public MonitoringAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeAlarmCompartmentResponse> changeAlarmCompartment(ChangeAlarmCompartmentRequest request, AsyncHandler<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse> handler) {
        LOG.trace("Called async changeAlarmCompartment");
        final ChangeAlarmCompartmentRequest interceptedRequest = ChangeAlarmCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeAlarmCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeAlarmCompartmentResponse> transformer = ChangeAlarmCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse> onSuccess = new SuccessConsumer<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeAlarmCompartmentRequest> onError = new ErrorConsumer<ChangeAlarmCompartmentRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getChangeAlarmCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeAlarmCompartmentRequest, ChangeAlarmCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeAlarmCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeAlarmCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeAlarmCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeAlarmCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getChangeAlarmCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeAlarmCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAlarmResponse> createAlarm(CreateAlarmRequest request, AsyncHandler<CreateAlarmRequest, CreateAlarmResponse> handler) {
        LOG.trace("Called async createAlarm");
        final CreateAlarmRequest interceptedRequest = CreateAlarmConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAlarmConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAlarmResponse> transformer = CreateAlarmConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAlarmRequest, CreateAlarmResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAlarmRequest, CreateAlarmResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAlarmRequest, CreateAlarmResponse> onSuccess = new SuccessConsumer<CreateAlarmRequest, CreateAlarmResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAlarmRequest> onError = new ErrorConsumer<CreateAlarmRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getCreateAlarmDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAlarmRequest, CreateAlarmResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAlarmRequest, CreateAlarmResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAlarmRequest> onError = handler == null ? null : new ErrorConsumer<CreateAlarmRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAlarmDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAlarmResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getCreateAlarmDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAlarmResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAlarmResponse> deleteAlarm(DeleteAlarmRequest request, AsyncHandler<DeleteAlarmRequest, DeleteAlarmResponse> handler) {
        LOG.trace("Called async deleteAlarm");
        final DeleteAlarmRequest interceptedRequest = DeleteAlarmConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAlarmConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAlarmResponse> transformer = DeleteAlarmConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAlarmRequest, DeleteAlarmResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAlarmRequest, DeleteAlarmResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAlarmRequest, DeleteAlarmResponse> onSuccess = new SuccessConsumer<DeleteAlarmRequest, DeleteAlarmResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAlarmRequest> onError = new ErrorConsumer<DeleteAlarmRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAlarmRequest, DeleteAlarmResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAlarmRequest, DeleteAlarmResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAlarmRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAlarmRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAlarmResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAlarmResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAlarmResponse> getAlarm(GetAlarmRequest request, AsyncHandler<GetAlarmRequest, GetAlarmResponse> handler) {
        LOG.trace("Called async getAlarm");
        final GetAlarmRequest interceptedRequest = GetAlarmConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAlarmConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAlarmResponse> transformer = GetAlarmConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAlarmRequest, GetAlarmResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAlarmRequest, GetAlarmResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAlarmRequest, GetAlarmResponse> onSuccess = new SuccessConsumer<GetAlarmRequest, GetAlarmResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAlarmRequest> onError = new ErrorConsumer<GetAlarmRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAlarmRequest, GetAlarmResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAlarmRequest, GetAlarmResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAlarmRequest> onError = handler == null ? null : new ErrorConsumer<GetAlarmRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAlarmResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAlarmResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAlarmHistoryResponse> getAlarmHistory(GetAlarmHistoryRequest request, AsyncHandler<GetAlarmHistoryRequest, GetAlarmHistoryResponse> handler) {
        LOG.trace("Called async getAlarmHistory");
        final GetAlarmHistoryRequest interceptedRequest = GetAlarmHistoryConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAlarmHistoryConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAlarmHistoryResponse> transformer = GetAlarmHistoryConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAlarmHistoryRequest, GetAlarmHistoryResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAlarmHistoryRequest, GetAlarmHistoryResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAlarmHistoryRequest, GetAlarmHistoryResponse> onSuccess = new SuccessConsumer<GetAlarmHistoryRequest, GetAlarmHistoryResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAlarmHistoryRequest> onError = new ErrorConsumer<GetAlarmHistoryRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAlarmHistoryRequest, GetAlarmHistoryResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAlarmHistoryRequest, GetAlarmHistoryResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAlarmHistoryRequest> onError = handler == null ? null : new ErrorConsumer<GetAlarmHistoryRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAlarmHistoryResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAlarmHistoryResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAlarmsResponse> listAlarms(ListAlarmsRequest request, AsyncHandler<ListAlarmsRequest, ListAlarmsResponse> handler) {
        LOG.trace("Called async listAlarms");
        final ListAlarmsRequest interceptedRequest = ListAlarmsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAlarmsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAlarmsResponse> transformer = ListAlarmsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAlarmsRequest, ListAlarmsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAlarmsRequest, ListAlarmsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAlarmsRequest, ListAlarmsResponse> onSuccess = new SuccessConsumer<ListAlarmsRequest, ListAlarmsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAlarmsRequest> onError = new ErrorConsumer<ListAlarmsRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAlarmsRequest, ListAlarmsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAlarmsRequest, ListAlarmsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAlarmsRequest> onError = handler == null ? null : new ErrorConsumer<ListAlarmsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAlarmsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAlarmsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAlarmsStatusResponse> listAlarmsStatus(ListAlarmsStatusRequest request, AsyncHandler<ListAlarmsStatusRequest, ListAlarmsStatusResponse> handler) {
        LOG.trace("Called async listAlarmsStatus");
        final ListAlarmsStatusRequest interceptedRequest = ListAlarmsStatusConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAlarmsStatusConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAlarmsStatusResponse> transformer = ListAlarmsStatusConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAlarmsStatusRequest, ListAlarmsStatusResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAlarmsStatusRequest, ListAlarmsStatusResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAlarmsStatusRequest, ListAlarmsStatusResponse> onSuccess = new SuccessConsumer<ListAlarmsStatusRequest, ListAlarmsStatusResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAlarmsStatusRequest> onError = new ErrorConsumer<ListAlarmsStatusRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAlarmsStatusRequest, ListAlarmsStatusResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAlarmsStatusRequest, ListAlarmsStatusResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAlarmsStatusRequest> onError = handler == null ? null : new ErrorConsumer<ListAlarmsStatusRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAlarmsStatusResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAlarmsStatusResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListMetricsResponse> listMetrics(ListMetricsRequest request, AsyncHandler<ListMetricsRequest, ListMetricsResponse> handler) {
        LOG.trace("Called async listMetrics");
        final ListMetricsRequest interceptedRequest = ListMetricsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListMetricsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListMetricsResponse> transformer = ListMetricsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListMetricsRequest, ListMetricsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListMetricsRequest, ListMetricsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListMetricsRequest, ListMetricsResponse> onSuccess = new SuccessConsumer<ListMetricsRequest, ListMetricsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListMetricsRequest> onError = new ErrorConsumer<ListMetricsRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getListMetricsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListMetricsRequest, ListMetricsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListMetricsRequest, ListMetricsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListMetricsRequest> onError = handler == null ? null : new ErrorConsumer<ListMetricsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getListMetricsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListMetricsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getListMetricsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListMetricsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PostMetricDataResponse> postMetricData(PostMetricDataRequest request, AsyncHandler<PostMetricDataRequest, PostMetricDataResponse> handler) {
        LOG.trace("Called async postMetricData");
        final PostMetricDataRequest interceptedRequest = PostMetricDataConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PostMetricDataConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PostMetricDataResponse> transformer = PostMetricDataConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<PostMetricDataRequest, PostMetricDataResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PostMetricDataRequest, PostMetricDataResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PostMetricDataRequest, PostMetricDataResponse> onSuccess = new SuccessConsumer<PostMetricDataRequest, PostMetricDataResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PostMetricDataRequest> onError = new ErrorConsumer<PostMetricDataRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getPostMetricDataDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PostMetricDataRequest, PostMetricDataResponse> onSuccess = handler == null ? null : new SuccessConsumer<PostMetricDataRequest, PostMetricDataResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PostMetricDataRequest> onError = handler == null ? null : new ErrorConsumer<PostMetricDataRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getPostMetricDataDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PostMetricDataResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getPostMetricDataDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PostMetricDataResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RemoveAlarmSuppressionResponse> removeAlarmSuppression(RemoveAlarmSuppressionRequest request, AsyncHandler<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse> handler) {
        LOG.trace("Called async removeAlarmSuppression");
        final RemoveAlarmSuppressionRequest interceptedRequest = RemoveAlarmSuppressionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RemoveAlarmSuppressionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RemoveAlarmSuppressionResponse> transformer = RemoveAlarmSuppressionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse> onSuccess = new SuccessConsumer<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RemoveAlarmSuppressionRequest> onError = new ErrorConsumer<RemoveAlarmSuppressionRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse> onSuccess = handler == null ? null : new SuccessConsumer<RemoveAlarmSuppressionRequest, RemoveAlarmSuppressionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RemoveAlarmSuppressionRequest> onError = handler == null ? null : new ErrorConsumer<RemoveAlarmSuppressionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RemoveAlarmSuppressionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RemoveAlarmSuppressionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<SummarizeMetricsDataResponse> summarizeMetricsData(SummarizeMetricsDataRequest request, AsyncHandler<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse> handler) {
        LOG.trace("Called async summarizeMetricsData");
        final SummarizeMetricsDataRequest interceptedRequest = SummarizeMetricsDataConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = SummarizeMetricsDataConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, SummarizeMetricsDataResponse> transformer = SummarizeMetricsDataConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse> onSuccess = new SuccessConsumer<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<SummarizeMetricsDataRequest> onError = new ErrorConsumer<SummarizeMetricsDataRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getSummarizeMetricsDataDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse> onSuccess = handler == null ? null : new SuccessConsumer<SummarizeMetricsDataRequest, SummarizeMetricsDataResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<SummarizeMetricsDataRequest> onError = handler == null ? null : new ErrorConsumer<SummarizeMetricsDataRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getSummarizeMetricsDataDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, SummarizeMetricsDataResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.post(ib, interceptedRequest.getSummarizeMetricsDataDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, SummarizeMetricsDataResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAlarmResponse> updateAlarm(UpdateAlarmRequest request, AsyncHandler<UpdateAlarmRequest, UpdateAlarmResponse> handler) {
        LOG.trace("Called async updateAlarm");
        final UpdateAlarmRequest interceptedRequest = UpdateAlarmConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAlarmConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAlarmResponse> transformer = UpdateAlarmConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAlarmRequest, UpdateAlarmResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAlarmRequest, UpdateAlarmResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAlarmRequest, UpdateAlarmResponse> onSuccess = new SuccessConsumer<UpdateAlarmRequest, UpdateAlarmResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAlarmRequest> onError = new ErrorConsumer<UpdateAlarmRequest>(this, interceptedRequest);
                    MonitoringAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAlarmDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAlarmRequest, UpdateAlarmResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAlarmRequest, UpdateAlarmResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAlarmRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAlarmRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAlarmDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAlarmResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return MonitoringAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAlarmDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAlarmResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MonitoringAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public MonitoringAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new MonitoringAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

