/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.monitoring.Monitoring;
import com.oracle.bmc.monitoring.MonitoringPaginators;
import com.oracle.bmc.monitoring.MonitoringWaiters;
import com.oracle.bmc.monitoring.internal.http.ChangeAlarmCompartmentConverter;
import com.oracle.bmc.monitoring.internal.http.CreateAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.DeleteAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.GetAlarmConverter;
import com.oracle.bmc.monitoring.internal.http.GetAlarmHistoryConverter;
import com.oracle.bmc.monitoring.internal.http.ListAlarmsConverter;
import com.oracle.bmc.monitoring.internal.http.ListAlarmsStatusConverter;
import com.oracle.bmc.monitoring.internal.http.ListMetricsConverter;
import com.oracle.bmc.monitoring.internal.http.PostMetricDataConverter;
import com.oracle.bmc.monitoring.internal.http.RemoveAlarmSuppressionConverter;
import com.oracle.bmc.monitoring.internal.http.SummarizeMetricsDataConverter;
import com.oracle.bmc.monitoring.internal.http.UpdateAlarmConverter;
import com.oracle.bmc.monitoring.requests.ChangeAlarmCompartmentRequest;
import com.oracle.bmc.monitoring.requests.CreateAlarmRequest;
import com.oracle.bmc.monitoring.requests.DeleteAlarmRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmHistoryRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.requests.RemoveAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.SummarizeMetricsDataRequest;
import com.oracle.bmc.monitoring.requests.UpdateAlarmRequest;
import com.oracle.bmc.monitoring.responses.ChangeAlarmCompartmentResponse;
import com.oracle.bmc.monitoring.responses.CreateAlarmResponse;
import com.oracle.bmc.monitoring.responses.DeleteAlarmResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmHistoryResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import com.oracle.bmc.monitoring.responses.RemoveAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.SummarizeMetricsDataResponse;
import com.oracle.bmc.monitoring.responses.UpdateAlarmResponse;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringClient
implements Monitoring {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoringClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("MONITORING").serviceEndpointPrefix("telemetry").serviceEndpointTemplate("https://telemetry.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final MonitoringWaiters waiters;
    private final MonitoringPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public MonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public MonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public MonitoringClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public MonitoringClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Monitoring-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new MonitoringWaiters(executorService, this);
        this.paginators = new MonitoringPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeAlarmCompartmentResponse changeAlarmCompartment(ChangeAlarmCompartmentRequest request) {
        LOG.trace("Called changeAlarmCompartment");
        ChangeAlarmCompartmentRequest interceptedRequest = ChangeAlarmCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAlarmCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAlarmCompartmentResponse> transformer = ChangeAlarmCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeAlarmCompartmentDetails(), retriedRequest);
                return (ChangeAlarmCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAlarmResponse createAlarm(CreateAlarmRequest request) {
        LOG.trace("Called createAlarm");
        CreateAlarmRequest interceptedRequest = CreateAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAlarmResponse> transformer = CreateAlarmConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAlarmDetails(), retriedRequest);
                return (CreateAlarmResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAlarmResponse deleteAlarm(DeleteAlarmRequest request) {
        LOG.trace("Called deleteAlarm");
        DeleteAlarmRequest interceptedRequest = DeleteAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAlarmResponse> transformer = DeleteAlarmConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteAlarmResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAlarmResponse getAlarm(GetAlarmRequest request) {
        LOG.trace("Called getAlarm");
        GetAlarmRequest interceptedRequest = GetAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAlarmResponse> transformer = GetAlarmConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAlarmResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAlarmHistoryResponse getAlarmHistory(GetAlarmHistoryRequest request) {
        LOG.trace("Called getAlarmHistory");
        GetAlarmHistoryRequest interceptedRequest = GetAlarmHistoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAlarmHistoryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAlarmHistoryResponse> transformer = GetAlarmHistoryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAlarmHistoryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAlarmsResponse listAlarms(ListAlarmsRequest request) {
        LOG.trace("Called listAlarms");
        ListAlarmsRequest interceptedRequest = ListAlarmsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAlarmsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAlarmsResponse> transformer = ListAlarmsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAlarmsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAlarmsStatusResponse listAlarmsStatus(ListAlarmsStatusRequest request) {
        LOG.trace("Called listAlarmsStatus");
        ListAlarmsStatusRequest interceptedRequest = ListAlarmsStatusConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAlarmsStatusConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAlarmsStatusResponse> transformer = ListAlarmsStatusConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAlarmsStatusResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMetricsResponse listMetrics(ListMetricsRequest request) {
        LOG.trace("Called listMetrics");
        ListMetricsRequest interceptedRequest = ListMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMetricsResponse> transformer = ListMetricsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getListMetricsDetails(), retriedRequest);
                return (ListMetricsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PostMetricDataResponse postMetricData(PostMetricDataRequest request) {
        LOG.trace("Called postMetricData");
        PostMetricDataRequest interceptedRequest = PostMetricDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PostMetricDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PostMetricDataResponse> transformer = PostMetricDataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getPostMetricDataDetails(), retriedRequest);
                return (PostMetricDataResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveAlarmSuppressionResponse removeAlarmSuppression(RemoveAlarmSuppressionRequest request) {
        LOG.trace("Called removeAlarmSuppression");
        RemoveAlarmSuppressionRequest interceptedRequest = RemoveAlarmSuppressionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveAlarmSuppressionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveAlarmSuppressionResponse> transformer = RemoveAlarmSuppressionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (RemoveAlarmSuppressionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SummarizeMetricsDataResponse summarizeMetricsData(SummarizeMetricsDataRequest request) {
        LOG.trace("Called summarizeMetricsData");
        SummarizeMetricsDataRequest interceptedRequest = SummarizeMetricsDataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SummarizeMetricsDataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SummarizeMetricsDataResponse> transformer = SummarizeMetricsDataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getSummarizeMetricsDataDetails(), retriedRequest);
                return (SummarizeMetricsDataResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAlarmResponse updateAlarm(UpdateAlarmRequest request) {
        LOG.trace("Called updateAlarm");
        UpdateAlarmRequest interceptedRequest = UpdateAlarmConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAlarmConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAlarmResponse> transformer = UpdateAlarmConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateAlarmDetails(), retriedRequest);
                return (UpdateAlarmResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public MonitoringWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public MonitoringPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, MonitoringClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public MonitoringClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new MonitoringClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

