/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.monitoring.Monitoring;
import com.oracle.bmc.monitoring.model.AlarmStatusSummary;
import com.oracle.bmc.monitoring.model.AlarmSummary;
import com.oracle.bmc.monitoring.model.Metric;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class MonitoringPaginators {
    private final Monitoring client;

    public Iterable<ListAlarmsResponse> listAlarmsResponseIterator(final ListAlarmsRequest request) {
        return new ResponseIterable<ListAlarmsRequest.Builder, ListAlarmsRequest, ListAlarmsResponse>(new Supplier<ListAlarmsRequest.Builder>(){

            public ListAlarmsRequest.Builder get() {
                return ListAlarmsRequest.builder().copy(request);
            }
        }, new Function<ListAlarmsResponse, String>(){

            public String apply(ListAlarmsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAlarmsRequest.Builder>, ListAlarmsRequest>(){

            public ListAlarmsRequest apply(RequestBuilderAndToken<ListAlarmsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAlarmsRequest, ListAlarmsResponse>(){

            public ListAlarmsResponse apply(ListAlarmsRequest request) {
                return MonitoringPaginators.this.client.listAlarms(request);
            }
        });
    }

    public Iterable<AlarmSummary> listAlarmsRecordIterator(final ListAlarmsRequest request) {
        return new ResponseRecordIterable<ListAlarmsRequest.Builder, ListAlarmsRequest, ListAlarmsResponse, AlarmSummary>(new Supplier<ListAlarmsRequest.Builder>(){

            public ListAlarmsRequest.Builder get() {
                return ListAlarmsRequest.builder().copy(request);
            }
        }, new Function<ListAlarmsResponse, String>(){

            public String apply(ListAlarmsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAlarmsRequest.Builder>, ListAlarmsRequest>(){

            public ListAlarmsRequest apply(RequestBuilderAndToken<ListAlarmsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAlarmsRequest, ListAlarmsResponse>(){

            public ListAlarmsResponse apply(ListAlarmsRequest request) {
                return MonitoringPaginators.this.client.listAlarms(request);
            }
        }, new Function<ListAlarmsResponse, List<AlarmSummary>>(){

            public List<AlarmSummary> apply(ListAlarmsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAlarmsStatusResponse> listAlarmsStatusResponseIterator(final ListAlarmsStatusRequest request) {
        return new ResponseIterable<ListAlarmsStatusRequest.Builder, ListAlarmsStatusRequest, ListAlarmsStatusResponse>(new Supplier<ListAlarmsStatusRequest.Builder>(){

            public ListAlarmsStatusRequest.Builder get() {
                return ListAlarmsStatusRequest.builder().copy(request);
            }
        }, new Function<ListAlarmsStatusResponse, String>(){

            public String apply(ListAlarmsStatusResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAlarmsStatusRequest.Builder>, ListAlarmsStatusRequest>(){

            public ListAlarmsStatusRequest apply(RequestBuilderAndToken<ListAlarmsStatusRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAlarmsStatusRequest, ListAlarmsStatusResponse>(){

            public ListAlarmsStatusResponse apply(ListAlarmsStatusRequest request) {
                return MonitoringPaginators.this.client.listAlarmsStatus(request);
            }
        });
    }

    public Iterable<AlarmStatusSummary> listAlarmsStatusRecordIterator(final ListAlarmsStatusRequest request) {
        return new ResponseRecordIterable<ListAlarmsStatusRequest.Builder, ListAlarmsStatusRequest, ListAlarmsStatusResponse, AlarmStatusSummary>(new Supplier<ListAlarmsStatusRequest.Builder>(){

            public ListAlarmsStatusRequest.Builder get() {
                return ListAlarmsStatusRequest.builder().copy(request);
            }
        }, new Function<ListAlarmsStatusResponse, String>(){

            public String apply(ListAlarmsStatusResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAlarmsStatusRequest.Builder>, ListAlarmsStatusRequest>(){

            public ListAlarmsStatusRequest apply(RequestBuilderAndToken<ListAlarmsStatusRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAlarmsStatusRequest, ListAlarmsStatusResponse>(){

            public ListAlarmsStatusResponse apply(ListAlarmsStatusRequest request) {
                return MonitoringPaginators.this.client.listAlarmsStatus(request);
            }
        }, new Function<ListAlarmsStatusResponse, List<AlarmStatusSummary>>(){

            public List<AlarmStatusSummary> apply(ListAlarmsStatusResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMetricsResponse> listMetricsResponseIterator(final ListMetricsRequest request) {
        return new ResponseIterable<ListMetricsRequest.Builder, ListMetricsRequest, ListMetricsResponse>(new Supplier<ListMetricsRequest.Builder>(){

            public ListMetricsRequest.Builder get() {
                return ListMetricsRequest.builder().copy(request);
            }
        }, new Function<ListMetricsResponse, String>(){

            public String apply(ListMetricsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMetricsRequest.Builder>, ListMetricsRequest>(){

            public ListMetricsRequest apply(RequestBuilderAndToken<ListMetricsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMetricsRequest, ListMetricsResponse>(){

            public ListMetricsResponse apply(ListMetricsRequest request) {
                return MonitoringPaginators.this.client.listMetrics(request);
            }
        });
    }

    public Iterable<Metric> listMetricsRecordIterator(final ListMetricsRequest request) {
        return new ResponseRecordIterable<ListMetricsRequest.Builder, ListMetricsRequest, ListMetricsResponse, Metric>(new Supplier<ListMetricsRequest.Builder>(){

            public ListMetricsRequest.Builder get() {
                return ListMetricsRequest.builder().copy(request);
            }
        }, new Function<ListMetricsResponse, String>(){

            public String apply(ListMetricsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMetricsRequest.Builder>, ListMetricsRequest>(){

            public ListMetricsRequest apply(RequestBuilderAndToken<ListMetricsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMetricsRequest, ListMetricsResponse>(){

            public ListMetricsResponse apply(ListMetricsRequest request) {
                return MonitoringPaginators.this.client.listMetrics(request);
            }
        }, new Function<ListMetricsResponse, List<Metric>>(){

            public List<Metric> apply(ListMetricsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public MonitoringPaginators(Monitoring client) {
        this.client = client;
    }
}

