/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.monitoring.Monitoring;
import com.oracle.bmc.monitoring.model.Alarm;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class MonitoringWaiters {
    private final ExecutorService executorService;
    private final Monitoring client;

    public Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(GetAlarmRequest request, Alarm.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlarm(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(GetAlarmRequest request, Alarm.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAlarm(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(GetAlarmRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Alarm.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAlarm(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(BmcGenericWaiter waiter, GetAlarmRequest request, Alarm.LifecycleState ... targetStates) {
        final HashSet<Alarm.LifecycleState> targetStatesSet = new HashSet<Alarm.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetAlarmRequest, GetAlarmResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetAlarmRequest, GetAlarmResponse>(){

            public GetAlarmResponse apply(GetAlarmRequest request) {
                return MonitoringWaiters.this.client.getAlarm(request);
            }
        }, new Predicate<GetAlarmResponse>(){

            public boolean apply(GetAlarmResponse response) {
                return targetStatesSet.contains((Object)response.getAlarm().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Alarm.LifecycleState.Deleted)), request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public MonitoringWaiters(ExecutorService executorService, Monitoring client) {
        this.executorService = executorService;
        this.client = client;
    }
}

