/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.monitoring.model.AlarmHistoryCollection;
import com.oracle.bmc.monitoring.requests.GetAlarmHistoryRequest;
import com.oracle.bmc.monitoring.responses.GetAlarmHistoryResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAlarmHistoryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAlarmHistoryConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAlarmHistoryRequest interceptRequest(GetAlarmHistoryRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAlarmHistoryRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAlarmId(), (String)"alarmId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180401").path("alarms").path(HttpUtils.encodePathSegment(request.getAlarmId())).path("history");
        if (request.getAlarmHistorytype() != null) {
            target = target.queryParam("alarmHistorytype", HttpUtils.attemptEncodeQueryParam(request.getAlarmHistorytype().getValue()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getTimestampGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timestampGreaterThanOrEqualTo", HttpUtils.attemptEncodeQueryParam(request.getTimestampGreaterThanOrEqualTo()));
        }
        if (request.getTimestampLessThan() != null) {
            target = target.queryParam("timestampLessThan", HttpUtils.attemptEncodeQueryParam(request.getTimestampLessThan()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetAlarmHistoryResponse> fromResponse() {
        Function<Response, GetAlarmHistoryResponse> transformer = new Function<Response, GetAlarmHistoryResponse>(){

            public GetAlarmHistoryResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                LOG.trace("Transform function invoked for GetAlarmHistoryResponse");
                Function<Response, WithHeaders<AlarmHistoryCollection>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AlarmHistoryCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetAlarmHistoryResponse.Builder builder = GetAlarmHistoryResponse.builder();
                builder.alarmHistoryCollection((AlarmHistoryCollection)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                GetAlarmHistoryResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

