/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.monitoring.model.CreateAlarmDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateAlarmRequest
extends BmcRequest {
    private CreateAlarmDetails createAlarmDetails;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"createAlarmDetails", "opcRequestId", "opcRetryToken"})
    CreateAlarmRequest(CreateAlarmDetails createAlarmDetails, String opcRequestId, String opcRetryToken) {
        this.createAlarmDetails = createAlarmDetails;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateAlarmDetails getCreateAlarmDetails() {
        return this.createAlarmDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder {
        private CreateAlarmDetails createAlarmDetails;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAlarmRequest o) {
            this.createAlarmDetails(o.getCreateAlarmDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAlarmRequest build() {
            CreateAlarmRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder createAlarmDetails(CreateAlarmDetails createAlarmDetails) {
            this.createAlarmDetails = createAlarmDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public CreateAlarmRequest buildWithoutInvocationCallback() {
            return new CreateAlarmRequest(this.createAlarmDetails, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "CreateAlarmRequest.Builder(createAlarmDetails=" + this.createAlarmDetails + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

