/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RemoveAlarmSuppressionRequest
extends BmcRequest {
    private String alarmId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"alarmId", "ifMatch", "opcRequestId"})
    RemoveAlarmSuppressionRequest(String alarmId, String ifMatch, String opcRequestId) {
        this.alarmId = alarmId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String alarmId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveAlarmSuppressionRequest o) {
            this.alarmId(o.getAlarmId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveAlarmSuppressionRequest build() {
            RemoveAlarmSuppressionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder alarmId(String alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RemoveAlarmSuppressionRequest buildWithoutInvocationCallback() {
            return new RemoveAlarmSuppressionRequest(this.alarmId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "RemoveAlarmSuppressionRequest.Builder(alarmId=" + this.alarmId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

