/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.responses;

import com.oracle.bmc.monitoring.model.Alarm;
import java.beans.ConstructorProperties;

public class CreateAlarmResponse {
    private String etag;
    private String opcRequestId;
    private Alarm alarm;

    @ConstructorProperties(value={"etag", "opcRequestId", "alarm"})
    CreateAlarmResponse(String etag, String opcRequestId, Alarm alarm) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.alarm = alarm;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Alarm getAlarm() {
        return this.alarm;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Alarm alarm;

        public Builder copy(CreateAlarmResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.alarm(o.getAlarm());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder alarm(Alarm alarm) {
            this.alarm = alarm;
            return this;
        }

        public CreateAlarmResponse build() {
            return new CreateAlarmResponse(this.etag, this.opcRequestId, this.alarm);
        }

        public String toString() {
            return "CreateAlarmResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", alarm=" + this.alarm + ")";
        }
    }
}

