/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.responses;

import com.oracle.bmc.monitoring.model.AlarmHistoryCollection;
import java.beans.ConstructorProperties;

public class GetAlarmHistoryResponse {
    private String opcRequestId;
    private String opcNextPage;
    private AlarmHistoryCollection alarmHistoryCollection;

    @ConstructorProperties(value={"opcRequestId", "opcNextPage", "alarmHistoryCollection"})
    GetAlarmHistoryResponse(String opcRequestId, String opcNextPage, AlarmHistoryCollection alarmHistoryCollection) {
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.alarmHistoryCollection = alarmHistoryCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public AlarmHistoryCollection getAlarmHistoryCollection() {
        return this.alarmHistoryCollection;
    }

    public static class Builder {
        private String opcRequestId;
        private String opcNextPage;
        private AlarmHistoryCollection alarmHistoryCollection;

        public Builder copy(GetAlarmHistoryResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.alarmHistoryCollection(o.getAlarmHistoryCollection());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder alarmHistoryCollection(AlarmHistoryCollection alarmHistoryCollection) {
            this.alarmHistoryCollection = alarmHistoryCollection;
            return this;
        }

        public GetAlarmHistoryResponse build() {
            return new GetAlarmHistoryResponse(this.opcRequestId, this.opcNextPage, this.alarmHistoryCollection);
        }

        public String toString() {
            return "GetAlarmHistoryResponse.Builder(opcRequestId=" + this.opcRequestId + ", opcNextPage=" + this.opcNextPage + ", alarmHistoryCollection=" + this.alarmHistoryCollection + ")";
        }
    }
}

