/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.responses;

import com.oracle.bmc.monitoring.model.AlarmSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListAlarmsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<AlarmSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListAlarmsResponse(String opcNextPage, String opcRequestId, List<AlarmSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<AlarmSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<AlarmSummary> items;

        public Builder copy(ListAlarmsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<AlarmSummary> items) {
            this.items = items;
            return this;
        }

        public ListAlarmsResponse build() {
            return new ListAlarmsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListAlarmsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

