/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.responses;

import com.oracle.bmc.monitoring.model.PostMetricDataResponseDetails;
import java.beans.ConstructorProperties;

public class PostMetricDataResponse {
    private String opcRequestId;
    private PostMetricDataResponseDetails postMetricDataResponseDetails;

    @ConstructorProperties(value={"opcRequestId", "postMetricDataResponseDetails"})
    PostMetricDataResponse(String opcRequestId, PostMetricDataResponseDetails postMetricDataResponseDetails) {
        this.opcRequestId = opcRequestId;
        this.postMetricDataResponseDetails = postMetricDataResponseDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PostMetricDataResponseDetails getPostMetricDataResponseDetails() {
        return this.postMetricDataResponseDetails;
    }

    public static class Builder {
        private String opcRequestId;
        private PostMetricDataResponseDetails postMetricDataResponseDetails;

        public Builder copy(PostMetricDataResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.postMetricDataResponseDetails(o.getPostMetricDataResponseDetails());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder postMetricDataResponseDetails(PostMetricDataResponseDetails postMetricDataResponseDetails) {
            this.postMetricDataResponseDetails = postMetricDataResponseDetails;
            return this;
        }

        public PostMetricDataResponse build() {
            return new PostMetricDataResponse(this.opcRequestId, this.postMetricDataResponseDetails);
        }

        public String toString() {
            return "PostMetricDataResponse.Builder(opcRequestId=" + this.opcRequestId + ", postMetricDataResponseDetails=" + this.postMetricDataResponseDetails + ")";
        }
    }
}

