/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.responses;

import com.oracle.bmc.monitoring.model.MetricData;
import java.beans.ConstructorProperties;
import java.util.List;

public class SummarizeMetricsDataResponse {
    private String opcRequestId;
    private List<MetricData> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    SummarizeMetricsDataResponse(String opcRequestId, List<MetricData> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<MetricData> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<MetricData> items;

        public Builder copy(SummarizeMetricsDataResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<MetricData> items) {
            this.items = items;
            return this;
        }

        public SummarizeMetricsDataResponse build() {
            return new SummarizeMetricsDataResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "SummarizeMetricsDataResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

