/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.objectstorage.ObjectStorageAsync;
import com.oracle.bmc.objectstorage.internal.http.AbortMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.CommitMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CopyObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CreatePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.DeletePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.GetBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.GetPreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.ListBucketsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadPartsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListPreauthenticatedRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.ReencryptBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.RenameObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.RestoreObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.UploadPartConverter;
import com.oracle.bmc.objectstorage.requests.AbortMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CancelWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.CommitMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CopyObjectRequest;
import com.oracle.bmc.objectstorage.requests.CreateBucketRequest;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CreatePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.DeleteBucketRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.requests.DeletePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.GetBucketRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.GetPreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.HeadBucketRequest;
import com.oracle.bmc.objectstorage.requests.HeadObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptBucketRequest;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.requests.RestoreObjectsRequest;
import com.oracle.bmc.objectstorage.requests.UpdateBucketRequest;
import com.oracle.bmc.objectstorage.requests.UpdateNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.AbortMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CancelWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CopyObjectResponse;
import com.oracle.bmc.objectstorage.responses.CreateBucketResponse;
import com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CreatePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.DeleteBucketResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import com.oracle.bmc.objectstorage.responses.DeletePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.GetBucketResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.GetPreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.HeadBucketResponse;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptBucketResponse;
import com.oracle.bmc.objectstorage.responses.RenameObjectResponse;
import com.oracle.bmc.objectstorage.responses.RestoreObjectsResponse;
import com.oracle.bmc.objectstorage.responses.UpdateBucketResponse;
import com.oracle.bmc.objectstorage.responses.UpdateNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorageAsyncClient
implements ObjectStorageAsync {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStorageAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OBJECTSTORAGE").serviceEndpointPrefix("objectstorage").serviceEndpointTemplate("https://objectstorage.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().defaultConfigurator(new DefaultConfigurator.NonBuffering()).clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AbortMultipartUploadResponse> abortMultipartUpload(AbortMultipartUploadRequest request, AsyncHandler<AbortMultipartUploadRequest, AbortMultipartUploadResponse> handler) {
        LOG.trace("Called async abortMultipartUpload");
        final AbortMultipartUploadRequest interceptedRequest = AbortMultipartUploadConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = AbortMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, AbortMultipartUploadResponse> transformer = AbortMultipartUploadConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<AbortMultipartUploadRequest, AbortMultipartUploadResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<AbortMultipartUploadRequest, AbortMultipartUploadResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<AbortMultipartUploadRequest, AbortMultipartUploadResponse> onSuccess = new SuccessConsumer<AbortMultipartUploadRequest, AbortMultipartUploadResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<AbortMultipartUploadRequest> onError = new ErrorConsumer<AbortMultipartUploadRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<AbortMultipartUploadRequest, AbortMultipartUploadResponse> onSuccess = handler == null ? null : new SuccessConsumer<AbortMultipartUploadRequest, AbortMultipartUploadResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<AbortMultipartUploadRequest> onError = handler == null ? null : new ErrorConsumer<AbortMultipartUploadRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, AbortMultipartUploadResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, AbortMultipartUploadResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        LOG.trace("Called async cancelWorkRequest");
        final CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse> onSuccess = new SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CancelWorkRequestRequest> onError = new ErrorConsumer<CancelWorkRequestRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<CancelWorkRequestRequest, CancelWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CancelWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<CancelWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CancelWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CancelWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CommitMultipartUploadResponse> commitMultipartUpload(CommitMultipartUploadRequest request, AsyncHandler<CommitMultipartUploadRequest, CommitMultipartUploadResponse> handler) {
        LOG.trace("Called async commitMultipartUpload");
        final CommitMultipartUploadRequest interceptedRequest = CommitMultipartUploadConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CommitMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CommitMultipartUploadResponse> transformer = CommitMultipartUploadConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CommitMultipartUploadRequest, CommitMultipartUploadResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CommitMultipartUploadRequest, CommitMultipartUploadResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CommitMultipartUploadRequest, CommitMultipartUploadResponse> onSuccess = new SuccessConsumer<CommitMultipartUploadRequest, CommitMultipartUploadResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CommitMultipartUploadRequest> onError = new ErrorConsumer<CommitMultipartUploadRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCommitMultipartUploadDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CommitMultipartUploadRequest, CommitMultipartUploadResponse> onSuccess = handler == null ? null : new SuccessConsumer<CommitMultipartUploadRequest, CommitMultipartUploadResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CommitMultipartUploadRequest> onError = handler == null ? null : new ErrorConsumer<CommitMultipartUploadRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCommitMultipartUploadDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CommitMultipartUploadResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCommitMultipartUploadDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CommitMultipartUploadResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CopyObjectResponse> copyObject(CopyObjectRequest request, AsyncHandler<CopyObjectRequest, CopyObjectResponse> handler) {
        LOG.trace("Called async copyObject");
        final CopyObjectRequest interceptedRequest = CopyObjectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CopyObjectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CopyObjectResponse> transformer = CopyObjectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CopyObjectRequest, CopyObjectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CopyObjectRequest, CopyObjectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CopyObjectRequest, CopyObjectResponse> onSuccess = new SuccessConsumer<CopyObjectRequest, CopyObjectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CopyObjectRequest> onError = new ErrorConsumer<CopyObjectRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCopyObjectDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CopyObjectRequest, CopyObjectResponse> onSuccess = handler == null ? null : new SuccessConsumer<CopyObjectRequest, CopyObjectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CopyObjectRequest> onError = handler == null ? null : new ErrorConsumer<CopyObjectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCopyObjectDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CopyObjectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCopyObjectDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CopyObjectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBucketResponse> createBucket(CreateBucketRequest request, AsyncHandler<CreateBucketRequest, CreateBucketResponse> handler) {
        LOG.trace("Called async createBucket");
        final CreateBucketRequest interceptedRequest = CreateBucketConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBucketConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBucketResponse> transformer = CreateBucketConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBucketRequest, CreateBucketResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBucketRequest, CreateBucketResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBucketRequest, CreateBucketResponse> onSuccess = new SuccessConsumer<CreateBucketRequest, CreateBucketResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBucketRequest> onError = new ErrorConsumer<CreateBucketRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateBucketDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBucketRequest, CreateBucketResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBucketRequest, CreateBucketResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBucketRequest> onError = handler == null ? null : new ErrorConsumer<CreateBucketRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBucketDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBucketResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateBucketDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBucketResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateMultipartUploadResponse> createMultipartUpload(CreateMultipartUploadRequest request, AsyncHandler<CreateMultipartUploadRequest, CreateMultipartUploadResponse> handler) {
        LOG.trace("Called async createMultipartUpload");
        final CreateMultipartUploadRequest interceptedRequest = CreateMultipartUploadConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateMultipartUploadResponse> transformer = CreateMultipartUploadConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateMultipartUploadRequest, CreateMultipartUploadResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateMultipartUploadRequest, CreateMultipartUploadResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateMultipartUploadRequest, CreateMultipartUploadResponse> onSuccess = new SuccessConsumer<CreateMultipartUploadRequest, CreateMultipartUploadResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateMultipartUploadRequest> onError = new ErrorConsumer<CreateMultipartUploadRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateMultipartUploadDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateMultipartUploadRequest, CreateMultipartUploadResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateMultipartUploadRequest, CreateMultipartUploadResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateMultipartUploadRequest> onError = handler == null ? null : new ErrorConsumer<CreateMultipartUploadRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateMultipartUploadDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateMultipartUploadResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreateMultipartUploadDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateMultipartUploadResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreatePreauthenticatedRequestResponse> createPreauthenticatedRequest(CreatePreauthenticatedRequestRequest request, AsyncHandler<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse> handler) {
        LOG.trace("Called async createPreauthenticatedRequest");
        final CreatePreauthenticatedRequestRequest interceptedRequest = CreatePreauthenticatedRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreatePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreatePreauthenticatedRequestResponse> transformer = CreatePreauthenticatedRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse> onSuccess = new SuccessConsumer<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreatePreauthenticatedRequestRequest> onError = new ErrorConsumer<CreatePreauthenticatedRequestRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreatePreauthenticatedRequestDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreatePreauthenticatedRequestRequest> onError = handler == null ? null : new ErrorConsumer<CreatePreauthenticatedRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreatePreauthenticatedRequestDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreatePreauthenticatedRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getCreatePreauthenticatedRequestDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreatePreauthenticatedRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBucketResponse> deleteBucket(DeleteBucketRequest request, AsyncHandler<DeleteBucketRequest, DeleteBucketResponse> handler) {
        LOG.trace("Called async deleteBucket");
        final DeleteBucketRequest interceptedRequest = DeleteBucketConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBucketConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBucketResponse> transformer = DeleteBucketConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBucketRequest, DeleteBucketResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBucketRequest, DeleteBucketResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBucketRequest, DeleteBucketResponse> onSuccess = new SuccessConsumer<DeleteBucketRequest, DeleteBucketResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBucketRequest> onError = new ErrorConsumer<DeleteBucketRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBucketRequest, DeleteBucketResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBucketRequest, DeleteBucketResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBucketRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBucketRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBucketResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBucketResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteObjectResponse> deleteObject(DeleteObjectRequest request, AsyncHandler<DeleteObjectRequest, DeleteObjectResponse> handler) {
        LOG.trace("Called async deleteObject");
        final DeleteObjectRequest interceptedRequest = DeleteObjectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteObjectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteObjectResponse> transformer = DeleteObjectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteObjectRequest, DeleteObjectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteObjectRequest, DeleteObjectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteObjectRequest, DeleteObjectResponse> onSuccess = new SuccessConsumer<DeleteObjectRequest, DeleteObjectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteObjectRequest> onError = new ErrorConsumer<DeleteObjectRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteObjectRequest, DeleteObjectResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteObjectRequest, DeleteObjectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteObjectRequest> onError = handler == null ? null : new ErrorConsumer<DeleteObjectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteObjectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteObjectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteObjectLifecyclePolicyResponse> deleteObjectLifecyclePolicy(DeleteObjectLifecyclePolicyRequest request, AsyncHandler<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse> handler) {
        LOG.trace("Called async deleteObjectLifecyclePolicy");
        final DeleteObjectLifecyclePolicyRequest interceptedRequest = DeleteObjectLifecyclePolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteObjectLifecyclePolicyResponse> transformer = DeleteObjectLifecyclePolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse> onSuccess = new SuccessConsumer<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteObjectLifecyclePolicyRequest> onError = new ErrorConsumer<DeleteObjectLifecyclePolicyRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteObjectLifecyclePolicyRequest> onError = handler == null ? null : new ErrorConsumer<DeleteObjectLifecyclePolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteObjectLifecyclePolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteObjectLifecyclePolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeletePreauthenticatedRequestResponse> deletePreauthenticatedRequest(DeletePreauthenticatedRequestRequest request, AsyncHandler<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse> handler) {
        LOG.trace("Called async deletePreauthenticatedRequest");
        final DeletePreauthenticatedRequestRequest interceptedRequest = DeletePreauthenticatedRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeletePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeletePreauthenticatedRequestResponse> transformer = DeletePreauthenticatedRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse> onSuccess = new SuccessConsumer<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeletePreauthenticatedRequestRequest> onError = new ErrorConsumer<DeletePreauthenticatedRequestRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeletePreauthenticatedRequestRequest> onError = handler == null ? null : new ErrorConsumer<DeletePreauthenticatedRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeletePreauthenticatedRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeletePreauthenticatedRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBucketResponse> getBucket(GetBucketRequest request, AsyncHandler<GetBucketRequest, GetBucketResponse> handler) {
        LOG.trace("Called async getBucket");
        final GetBucketRequest interceptedRequest = GetBucketConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBucketConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBucketResponse> transformer = GetBucketConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBucketRequest, GetBucketResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBucketRequest, GetBucketResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBucketRequest, GetBucketResponse> onSuccess = new SuccessConsumer<GetBucketRequest, GetBucketResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBucketRequest> onError = new ErrorConsumer<GetBucketRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBucketRequest, GetBucketResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBucketRequest, GetBucketResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBucketRequest> onError = handler == null ? null : new ErrorConsumer<GetBucketRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBucketResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBucketResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetNamespaceResponse> getNamespace(GetNamespaceRequest request, AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handler) {
        LOG.trace("Called async getNamespace");
        final GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetNamespaceRequest, GetNamespaceResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetNamespaceRequest, GetNamespaceResponse> onSuccess = new SuccessConsumer<GetNamespaceRequest, GetNamespaceResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetNamespaceRequest> onError = new ErrorConsumer<GetNamespaceRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetNamespaceRequest, GetNamespaceResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetNamespaceRequest, GetNamespaceResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetNamespaceRequest> onError = handler == null ? null : new ErrorConsumer<GetNamespaceRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetNamespaceResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetNamespaceResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetNamespaceMetadataResponse> getNamespaceMetadata(GetNamespaceMetadataRequest request, AsyncHandler<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse> handler) {
        LOG.trace("Called async getNamespaceMetadata");
        final GetNamespaceMetadataRequest interceptedRequest = GetNamespaceMetadataConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetNamespaceMetadataResponse> transformer = GetNamespaceMetadataConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse> onSuccess = new SuccessConsumer<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetNamespaceMetadataRequest> onError = new ErrorConsumer<GetNamespaceMetadataRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetNamespaceMetadataRequest> onError = handler == null ? null : new ErrorConsumer<GetNamespaceMetadataRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetNamespaceMetadataResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetNamespaceMetadataResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetObjectResponse> getObject(GetObjectRequest request, AsyncHandler<GetObjectRequest, GetObjectResponse> handler) {
        LOG.trace("Called async getObject");
        final GetObjectRequest interceptedRequest = GetObjectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetObjectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetObjectResponse> transformer = GetObjectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetObjectRequest, GetObjectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetObjectRequest, GetObjectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetObjectRequest, GetObjectResponse> onSuccess = new SuccessConsumer<GetObjectRequest, GetObjectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetObjectRequest> onError = new ErrorConsumer<GetObjectRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetObjectRequest, GetObjectResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetObjectRequest, GetObjectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetObjectRequest> onError = handler == null ? null : new ErrorConsumer<GetObjectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetObjectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetObjectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetObjectLifecyclePolicyResponse> getObjectLifecyclePolicy(GetObjectLifecyclePolicyRequest request, AsyncHandler<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse> handler) {
        LOG.trace("Called async getObjectLifecyclePolicy");
        final GetObjectLifecyclePolicyRequest interceptedRequest = GetObjectLifecyclePolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetObjectLifecyclePolicyResponse> transformer = GetObjectLifecyclePolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse> onSuccess = new SuccessConsumer<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetObjectLifecyclePolicyRequest> onError = new ErrorConsumer<GetObjectLifecyclePolicyRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetObjectLifecyclePolicyRequest> onError = handler == null ? null : new ErrorConsumer<GetObjectLifecyclePolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetObjectLifecyclePolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetObjectLifecyclePolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetPreauthenticatedRequestResponse> getPreauthenticatedRequest(GetPreauthenticatedRequestRequest request, AsyncHandler<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse> handler) {
        LOG.trace("Called async getPreauthenticatedRequest");
        final GetPreauthenticatedRequestRequest interceptedRequest = GetPreauthenticatedRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetPreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetPreauthenticatedRequestResponse> transformer = GetPreauthenticatedRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse> onSuccess = new SuccessConsumer<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetPreauthenticatedRequestRequest> onError = new ErrorConsumer<GetPreauthenticatedRequestRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetPreauthenticatedRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetPreauthenticatedRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetPreauthenticatedRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetPreauthenticatedRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        final GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetWorkRequestRequest> onError = new ErrorConsumer<GetWorkRequestRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetWorkRequestRequest, GetWorkRequestResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetWorkRequestRequest> onError = handler == null ? null : new ErrorConsumer<GetWorkRequestRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetWorkRequestResponse>(responseFuture, transformer);
    }

    @Override
    public Future<HeadBucketResponse> headBucket(HeadBucketRequest request, AsyncHandler<HeadBucketRequest, HeadBucketResponse> handler) {
        LOG.trace("Called async headBucket");
        final HeadBucketRequest interceptedRequest = HeadBucketConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = HeadBucketConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, HeadBucketResponse> transformer = HeadBucketConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<HeadBucketRequest, HeadBucketResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<HeadBucketRequest, HeadBucketResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<HeadBucketRequest, HeadBucketResponse> onSuccess = new SuccessConsumer<HeadBucketRequest, HeadBucketResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<HeadBucketRequest> onError = new ErrorConsumer<HeadBucketRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.head(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<HeadBucketRequest, HeadBucketResponse> onSuccess = handler == null ? null : new SuccessConsumer<HeadBucketRequest, HeadBucketResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<HeadBucketRequest> onError = handler == null ? null : new ErrorConsumer<HeadBucketRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.head(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, HeadBucketResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.head(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, HeadBucketResponse>(responseFuture, transformer);
    }

    @Override
    public Future<HeadObjectResponse> headObject(HeadObjectRequest request, AsyncHandler<HeadObjectRequest, HeadObjectResponse> handler) {
        LOG.trace("Called async headObject");
        final HeadObjectRequest interceptedRequest = HeadObjectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = HeadObjectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, HeadObjectResponse> transformer = HeadObjectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<HeadObjectRequest, HeadObjectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<HeadObjectRequest, HeadObjectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<HeadObjectRequest, HeadObjectResponse> onSuccess = new SuccessConsumer<HeadObjectRequest, HeadObjectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<HeadObjectRequest> onError = new ErrorConsumer<HeadObjectRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.head(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<HeadObjectRequest, HeadObjectResponse> onSuccess = handler == null ? null : new SuccessConsumer<HeadObjectRequest, HeadObjectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<HeadObjectRequest> onError = handler == null ? null : new ErrorConsumer<HeadObjectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.head(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, HeadObjectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.head(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, HeadObjectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBucketsResponse> listBuckets(ListBucketsRequest request, AsyncHandler<ListBucketsRequest, ListBucketsResponse> handler) {
        LOG.trace("Called async listBuckets");
        final ListBucketsRequest interceptedRequest = ListBucketsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBucketsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBucketsResponse> transformer = ListBucketsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBucketsRequest, ListBucketsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBucketsRequest, ListBucketsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBucketsRequest, ListBucketsResponse> onSuccess = new SuccessConsumer<ListBucketsRequest, ListBucketsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBucketsRequest> onError = new ErrorConsumer<ListBucketsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBucketsRequest, ListBucketsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBucketsRequest, ListBucketsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBucketsRequest> onError = handler == null ? null : new ErrorConsumer<ListBucketsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBucketsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBucketsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListMultipartUploadPartsResponse> listMultipartUploadParts(ListMultipartUploadPartsRequest request, AsyncHandler<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse> handler) {
        LOG.trace("Called async listMultipartUploadParts");
        final ListMultipartUploadPartsRequest interceptedRequest = ListMultipartUploadPartsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListMultipartUploadPartsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListMultipartUploadPartsResponse> transformer = ListMultipartUploadPartsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse> onSuccess = new SuccessConsumer<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListMultipartUploadPartsRequest> onError = new ErrorConsumer<ListMultipartUploadPartsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListMultipartUploadPartsRequest> onError = handler == null ? null : new ErrorConsumer<ListMultipartUploadPartsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListMultipartUploadPartsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListMultipartUploadPartsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListMultipartUploadsResponse> listMultipartUploads(ListMultipartUploadsRequest request, AsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResponse> handler) {
        LOG.trace("Called async listMultipartUploads");
        final ListMultipartUploadsRequest interceptedRequest = ListMultipartUploadsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListMultipartUploadsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListMultipartUploadsResponse> transformer = ListMultipartUploadsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListMultipartUploadsRequest, ListMultipartUploadsResponse> onSuccess = new SuccessConsumer<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListMultipartUploadsRequest> onError = new ErrorConsumer<ListMultipartUploadsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListMultipartUploadsRequest, ListMultipartUploadsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListMultipartUploadsRequest> onError = handler == null ? null : new ErrorConsumer<ListMultipartUploadsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListMultipartUploadsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListMultipartUploadsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListObjectsResponse> listObjects(ListObjectsRequest request, AsyncHandler<ListObjectsRequest, ListObjectsResponse> handler) {
        LOG.trace("Called async listObjects");
        final ListObjectsRequest interceptedRequest = ListObjectsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListObjectsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListObjectsResponse> transformer = ListObjectsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListObjectsRequest, ListObjectsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListObjectsRequest, ListObjectsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListObjectsRequest, ListObjectsResponse> onSuccess = new SuccessConsumer<ListObjectsRequest, ListObjectsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListObjectsRequest> onError = new ErrorConsumer<ListObjectsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListObjectsRequest, ListObjectsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListObjectsRequest, ListObjectsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListObjectsRequest> onError = handler == null ? null : new ErrorConsumer<ListObjectsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListObjectsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListObjectsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListPreauthenticatedRequestsResponse> listPreauthenticatedRequests(ListPreauthenticatedRequestsRequest request, AsyncHandler<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse> handler) {
        LOG.trace("Called async listPreauthenticatedRequests");
        final ListPreauthenticatedRequestsRequest interceptedRequest = ListPreauthenticatedRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListPreauthenticatedRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListPreauthenticatedRequestsResponse> transformer = ListPreauthenticatedRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse> onSuccess = new SuccessConsumer<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListPreauthenticatedRequestsRequest> onError = new ErrorConsumer<ListPreauthenticatedRequestsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListPreauthenticatedRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListPreauthenticatedRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListPreauthenticatedRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListPreauthenticatedRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        final ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestErrorsRequest> onError = new ErrorConsumer<ListWorkRequestErrorsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestErrorsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestErrorsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestErrorsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        final ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestLogsRequest> onError = new ErrorConsumer<ListWorkRequestLogsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestLogsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestLogsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestLogsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        final ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListWorkRequestsRequest> onError = new ErrorConsumer<ListWorkRequestsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListWorkRequestsRequest, ListWorkRequestsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListWorkRequestsRequest> onError = handler == null ? null : new ErrorConsumer<ListWorkRequestsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListWorkRequestsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PutObjectResponse> putObject(PutObjectRequest request, AsyncHandler<PutObjectRequest, PutObjectResponse> handler) {
        LOG.trace("Called async putObject");
        final PutObjectRequest interceptedRequest = PutObjectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PutObjectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PutObjectResponse> transformer = PutObjectConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        RefreshAuthTokenWrappingAsyncHandler<PutObjectRequest, PutObjectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PutObjectRequest, PutObjectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PutObjectRequest, PutObjectResponse> onSuccess = new SuccessConsumer<PutObjectRequest, PutObjectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PutObjectRequest> onError = new ErrorConsumer<PutObjectRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getPutObjectBody(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PutObjectRequest, PutObjectResponse> onSuccess = handler == null ? null : new SuccessConsumer<PutObjectRequest, PutObjectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PutObjectRequest> onError = handler == null ? null : new ErrorConsumer<PutObjectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getPutObjectBody(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PutObjectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getPutObjectBody(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PutObjectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<PutObjectLifecyclePolicyResponse> putObjectLifecyclePolicy(PutObjectLifecyclePolicyRequest request, AsyncHandler<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse> handler) {
        LOG.trace("Called async putObjectLifecyclePolicy");
        final PutObjectLifecyclePolicyRequest interceptedRequest = PutObjectLifecyclePolicyConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = PutObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, PutObjectLifecyclePolicyResponse> transformer = PutObjectLifecyclePolicyConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse> onSuccess = new SuccessConsumer<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<PutObjectLifecyclePolicyRequest> onError = new ErrorConsumer<PutObjectLifecyclePolicyRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getPutObjectLifecyclePolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse> onSuccess = handler == null ? null : new SuccessConsumer<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<PutObjectLifecyclePolicyRequest> onError = handler == null ? null : new ErrorConsumer<PutObjectLifecyclePolicyRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getPutObjectLifecyclePolicyDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, PutObjectLifecyclePolicyResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getPutObjectLifecyclePolicyDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, PutObjectLifecyclePolicyResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ReencryptBucketResponse> reencryptBucket(ReencryptBucketRequest request, AsyncHandler<ReencryptBucketRequest, ReencryptBucketResponse> handler) {
        LOG.trace("Called async reencryptBucket");
        final ReencryptBucketRequest interceptedRequest = ReencryptBucketConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ReencryptBucketConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ReencryptBucketResponse> transformer = ReencryptBucketConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ReencryptBucketRequest, ReencryptBucketResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ReencryptBucketRequest, ReencryptBucketResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ReencryptBucketRequest, ReencryptBucketResponse> onSuccess = new SuccessConsumer<ReencryptBucketRequest, ReencryptBucketResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ReencryptBucketRequest> onError = new ErrorConsumer<ReencryptBucketRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ReencryptBucketRequest, ReencryptBucketResponse> onSuccess = handler == null ? null : new SuccessConsumer<ReencryptBucketRequest, ReencryptBucketResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ReencryptBucketRequest> onError = handler == null ? null : new ErrorConsumer<ReencryptBucketRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ReencryptBucketResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ReencryptBucketResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RenameObjectResponse> renameObject(RenameObjectRequest request, AsyncHandler<RenameObjectRequest, RenameObjectResponse> handler) {
        LOG.trace("Called async renameObject");
        final RenameObjectRequest interceptedRequest = RenameObjectConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RenameObjectConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RenameObjectResponse> transformer = RenameObjectConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RenameObjectRequest, RenameObjectResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RenameObjectRequest, RenameObjectResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RenameObjectRequest, RenameObjectResponse> onSuccess = new SuccessConsumer<RenameObjectRequest, RenameObjectResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RenameObjectRequest> onError = new ErrorConsumer<RenameObjectRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getRenameObjectDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RenameObjectRequest, RenameObjectResponse> onSuccess = handler == null ? null : new SuccessConsumer<RenameObjectRequest, RenameObjectResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RenameObjectRequest> onError = handler == null ? null : new ErrorConsumer<RenameObjectRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getRenameObjectDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RenameObjectResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getRenameObjectDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RenameObjectResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RestoreObjectsResponse> restoreObjects(RestoreObjectsRequest request, AsyncHandler<RestoreObjectsRequest, RestoreObjectsResponse> handler) {
        LOG.trace("Called async restoreObjects");
        final RestoreObjectsRequest interceptedRequest = RestoreObjectsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RestoreObjectsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RestoreObjectsResponse> transformer = RestoreObjectsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RestoreObjectsRequest, RestoreObjectsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RestoreObjectsRequest, RestoreObjectsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RestoreObjectsRequest, RestoreObjectsResponse> onSuccess = new SuccessConsumer<RestoreObjectsRequest, RestoreObjectsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RestoreObjectsRequest> onError = new ErrorConsumer<RestoreObjectsRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getRestoreObjectsDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RestoreObjectsRequest, RestoreObjectsResponse> onSuccess = handler == null ? null : new SuccessConsumer<RestoreObjectsRequest, RestoreObjectsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RestoreObjectsRequest> onError = handler == null ? null : new ErrorConsumer<RestoreObjectsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getRestoreObjectsDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RestoreObjectsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getRestoreObjectsDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RestoreObjectsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBucketResponse> updateBucket(UpdateBucketRequest request, AsyncHandler<UpdateBucketRequest, UpdateBucketResponse> handler) {
        LOG.trace("Called async updateBucket");
        final UpdateBucketRequest interceptedRequest = UpdateBucketConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBucketConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBucketResponse> transformer = UpdateBucketConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBucketRequest, UpdateBucketResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBucketRequest, UpdateBucketResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBucketRequest, UpdateBucketResponse> onSuccess = new SuccessConsumer<UpdateBucketRequest, UpdateBucketResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBucketRequest> onError = new ErrorConsumer<UpdateBucketRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getUpdateBucketDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBucketRequest, UpdateBucketResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBucketRequest, UpdateBucketResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBucketRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBucketRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getUpdateBucketDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBucketResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.post(ib, interceptedRequest.getUpdateBucketDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBucketResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateNamespaceMetadataResponse> updateNamespaceMetadata(UpdateNamespaceMetadataRequest request, AsyncHandler<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse> handler) {
        LOG.trace("Called async updateNamespaceMetadata");
        final UpdateNamespaceMetadataRequest interceptedRequest = UpdateNamespaceMetadataConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateNamespaceMetadataResponse> transformer = UpdateNamespaceMetadataConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse> onSuccess = new SuccessConsumer<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateNamespaceMetadataRequest> onError = new ErrorConsumer<UpdateNamespaceMetadataRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNamespaceMetadataDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateNamespaceMetadataRequest> onError = handler == null ? null : new ErrorConsumer<UpdateNamespaceMetadataRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateNamespaceMetadataDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateNamespaceMetadataResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getUpdateNamespaceMetadataDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateNamespaceMetadataResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UploadPartResponse> uploadPart(UploadPartRequest request, AsyncHandler<UploadPartRequest, UploadPartResponse> handler) {
        LOG.trace("Called async uploadPart");
        final UploadPartRequest interceptedRequest = UploadPartConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UploadPartConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UploadPartResponse> transformer = UploadPartConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        RefreshAuthTokenWrappingAsyncHandler<UploadPartRequest, UploadPartResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UploadPartRequest, UploadPartResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UploadPartRequest, UploadPartResponse> onSuccess = new SuccessConsumer<UploadPartRequest, UploadPartResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UploadPartRequest> onError = new ErrorConsumer<UploadPartRequest>(this, interceptedRequest);
                    ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getUploadPartBody(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UploadPartRequest, UploadPartResponse> onSuccess = handler == null ? null : new SuccessConsumer<UploadPartRequest, UploadPartResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UploadPartRequest> onError = handler == null ? null : new ErrorConsumer<UploadPartRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUploadPartBody(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UploadPartResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return ObjectStorageAsyncClient.this.client.put(ib, interceptedRequest.getUploadPartBody(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UploadPartResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ObjectStorageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public ObjectStorageAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ObjectStorageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

