/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.ObjectStoragePaginators;
import com.oracle.bmc.objectstorage.ObjectStorageWaiters;
import com.oracle.bmc.objectstorage.internal.http.AbortMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CancelWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.CommitMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CopyObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.CreateMultipartUploadConverter;
import com.oracle.bmc.objectstorage.internal.http.CreatePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.DeleteObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.DeletePreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.GetBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceConverter;
import com.oracle.bmc.objectstorage.internal.http.GetNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.GetObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.GetPreauthenticatedRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.HeadObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.ListBucketsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadPartsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListMultipartUploadsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListPreauthenticatedRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.objectstorage.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.PutObjectLifecyclePolicyConverter;
import com.oracle.bmc.objectstorage.internal.http.ReencryptBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.RenameObjectConverter;
import com.oracle.bmc.objectstorage.internal.http.RestoreObjectsConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateBucketConverter;
import com.oracle.bmc.objectstorage.internal.http.UpdateNamespaceMetadataConverter;
import com.oracle.bmc.objectstorage.internal.http.UploadPartConverter;
import com.oracle.bmc.objectstorage.requests.AbortMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CancelWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.CommitMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CopyObjectRequest;
import com.oracle.bmc.objectstorage.requests.CreateBucketRequest;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CreatePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.DeleteBucketRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.requests.DeletePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.GetBucketRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.GetPreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.HeadBucketRequest;
import com.oracle.bmc.objectstorage.requests.HeadObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptBucketRequest;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.requests.RestoreObjectsRequest;
import com.oracle.bmc.objectstorage.requests.UpdateBucketRequest;
import com.oracle.bmc.objectstorage.requests.UpdateNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.AbortMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CancelWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CopyObjectResponse;
import com.oracle.bmc.objectstorage.responses.CreateBucketResponse;
import com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CreatePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.DeleteBucketResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import com.oracle.bmc.objectstorage.responses.DeletePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.GetBucketResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.GetPreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.HeadBucketResponse;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptBucketResponse;
import com.oracle.bmc.objectstorage.responses.RenameObjectResponse;
import com.oracle.bmc.objectstorage.responses.RestoreObjectsResponse;
import com.oracle.bmc.objectstorage.responses.UpdateBucketResponse;
import com.oracle.bmc.objectstorage.responses.UpdateNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorageClient
implements ObjectStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStorageClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OBJECTSTORAGE").serviceEndpointPrefix("objectstorage").serviceEndpointTemplate("https://objectstorage.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final ObjectStorageWaiters waiters;
    private final ObjectStoragePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public ObjectStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public ObjectStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public ObjectStorageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public ObjectStorageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().defaultConfigurator(new DefaultConfigurator.NonBuffering()).clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ObjectStorage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ObjectStorageWaiters(executorService, this);
        this.paginators = new ObjectStoragePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AbortMultipartUploadResponse abortMultipartUpload(AbortMultipartUploadRequest request) {
        LOG.trace("Called abortMultipartUpload");
        AbortMultipartUploadRequest interceptedRequest = AbortMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AbortMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AbortMultipartUploadResponse> transformer = AbortMultipartUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (AbortMultipartUploadResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        LOG.trace("Called cancelWorkRequest");
        CancelWorkRequestRequest interceptedRequest = CancelWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelWorkRequestResponse> transformer = CancelWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (CancelWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CommitMultipartUploadResponse commitMultipartUpload(CommitMultipartUploadRequest request) {
        LOG.trace("Called commitMultipartUpload");
        CommitMultipartUploadRequest interceptedRequest = CommitMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CommitMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CommitMultipartUploadResponse> transformer = CommitMultipartUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCommitMultipartUploadDetails(), retriedRequest);
                return (CommitMultipartUploadResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CopyObjectResponse copyObject(CopyObjectRequest request) {
        LOG.trace("Called copyObject");
        CopyObjectRequest interceptedRequest = CopyObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CopyObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CopyObjectResponse> transformer = CopyObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCopyObjectDetails(), retriedRequest);
                return (CopyObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBucketResponse createBucket(CreateBucketRequest request) {
        LOG.trace("Called createBucket");
        CreateBucketRequest interceptedRequest = CreateBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBucketResponse> transformer = CreateBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateBucketDetails(), retriedRequest);
                return (CreateBucketResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateMultipartUploadResponse createMultipartUpload(CreateMultipartUploadRequest request) {
        LOG.trace("Called createMultipartUpload");
        CreateMultipartUploadRequest interceptedRequest = CreateMultipartUploadConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateMultipartUploadConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateMultipartUploadResponse> transformer = CreateMultipartUploadConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateMultipartUploadDetails(), retriedRequest);
                return (CreateMultipartUploadResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePreauthenticatedRequestResponse createPreauthenticatedRequest(CreatePreauthenticatedRequestRequest request) {
        LOG.trace("Called createPreauthenticatedRequest");
        CreatePreauthenticatedRequestRequest interceptedRequest = CreatePreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePreauthenticatedRequestResponse> transformer = CreatePreauthenticatedRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreatePreauthenticatedRequestDetails(), retriedRequest);
                return (CreatePreauthenticatedRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBucketResponse deleteBucket(DeleteBucketRequest request) {
        LOG.trace("Called deleteBucket");
        DeleteBucketRequest interceptedRequest = DeleteBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBucketResponse> transformer = DeleteBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteBucketResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest request) {
        LOG.trace("Called deleteObject");
        DeleteObjectRequest interceptedRequest = DeleteObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteObjectResponse> transformer = DeleteObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteObjectLifecyclePolicyResponse deleteObjectLifecyclePolicy(DeleteObjectLifecyclePolicyRequest request) {
        LOG.trace("Called deleteObjectLifecyclePolicy");
        DeleteObjectLifecyclePolicyRequest interceptedRequest = DeleteObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteObjectLifecyclePolicyResponse> transformer = DeleteObjectLifecyclePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteObjectLifecyclePolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePreauthenticatedRequestResponse deletePreauthenticatedRequest(DeletePreauthenticatedRequestRequest request) {
        LOG.trace("Called deletePreauthenticatedRequest");
        DeletePreauthenticatedRequestRequest interceptedRequest = DeletePreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePreauthenticatedRequestResponse> transformer = DeletePreauthenticatedRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeletePreauthenticatedRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBucketResponse getBucket(GetBucketRequest request) {
        LOG.trace("Called getBucket");
        GetBucketRequest interceptedRequest = GetBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBucketResponse> transformer = GetBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetBucketResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest request) {
        LOG.trace("Called getNamespace");
        GetNamespaceRequest interceptedRequest = GetNamespaceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNamespaceResponse> transformer = GetNamespaceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetNamespaceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetNamespaceMetadataResponse getNamespaceMetadata(GetNamespaceMetadataRequest request) {
        LOG.trace("Called getNamespaceMetadata");
        GetNamespaceMetadataRequest interceptedRequest = GetNamespaceMetadataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetNamespaceMetadataResponse> transformer = GetNamespaceMetadataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetNamespaceMetadataResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetObjectResponse getObject(GetObjectRequest request) {
        LOG.trace("Called getObject");
        GetObjectRequest interceptedRequest = GetObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetObjectResponse> transformer = GetObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetObjectLifecyclePolicyResponse getObjectLifecyclePolicy(GetObjectLifecyclePolicyRequest request) {
        LOG.trace("Called getObjectLifecyclePolicy");
        GetObjectLifecyclePolicyRequest interceptedRequest = GetObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetObjectLifecyclePolicyResponse> transformer = GetObjectLifecyclePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetObjectLifecyclePolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPreauthenticatedRequestResponse getPreauthenticatedRequest(GetPreauthenticatedRequestRequest request) {
        LOG.trace("Called getPreauthenticatedRequest");
        GetPreauthenticatedRequestRequest interceptedRequest = GetPreauthenticatedRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPreauthenticatedRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPreauthenticatedRequestResponse> transformer = GetPreauthenticatedRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetPreauthenticatedRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public HeadBucketResponse headBucket(HeadBucketRequest request) {
        LOG.trace("Called headBucket");
        HeadBucketRequest interceptedRequest = HeadBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, HeadBucketResponse> transformer = HeadBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, retriedRequest);
                return (HeadBucketResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public HeadObjectResponse headObject(HeadObjectRequest request) {
        LOG.trace("Called headObject");
        HeadObjectRequest interceptedRequest = HeadObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = HeadObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, HeadObjectResponse> transformer = HeadObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.head(ib, retriedRequest);
                return (HeadObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBucketsResponse listBuckets(ListBucketsRequest request) {
        LOG.trace("Called listBuckets");
        ListBucketsRequest interceptedRequest = ListBucketsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBucketsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBucketsResponse> transformer = ListBucketsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListBucketsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMultipartUploadPartsResponse listMultipartUploadParts(ListMultipartUploadPartsRequest request) {
        LOG.trace("Called listMultipartUploadParts");
        ListMultipartUploadPartsRequest interceptedRequest = ListMultipartUploadPartsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMultipartUploadPartsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMultipartUploadPartsResponse> transformer = ListMultipartUploadPartsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListMultipartUploadPartsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMultipartUploadsResponse listMultipartUploads(ListMultipartUploadsRequest request) {
        LOG.trace("Called listMultipartUploads");
        ListMultipartUploadsRequest interceptedRequest = ListMultipartUploadsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMultipartUploadsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMultipartUploadsResponse> transformer = ListMultipartUploadsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListMultipartUploadsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListObjectsResponse listObjects(ListObjectsRequest request) {
        LOG.trace("Called listObjects");
        ListObjectsRequest interceptedRequest = ListObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListObjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListObjectsResponse> transformer = ListObjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListObjectsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPreauthenticatedRequestsResponse listPreauthenticatedRequests(ListPreauthenticatedRequestsRequest request) {
        LOG.trace("Called listPreauthenticatedRequests");
        ListPreauthenticatedRequestsRequest interceptedRequest = ListPreauthenticatedRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPreauthenticatedRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPreauthenticatedRequestsResponse> transformer = ListPreauthenticatedRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListPreauthenticatedRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PutObjectResponse putObject(PutObjectRequest request) {
        LOG.trace("Called putObject");
        PutObjectRequest interceptedRequest = PutObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PutObjectResponse> transformer = PutObjectConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getPutObjectBody(), retriedRequest);
                return (PutObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public PutObjectLifecyclePolicyResponse putObjectLifecyclePolicy(PutObjectLifecyclePolicyRequest request) {
        LOG.trace("Called putObjectLifecyclePolicy");
        PutObjectLifecyclePolicyRequest interceptedRequest = PutObjectLifecyclePolicyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutObjectLifecyclePolicyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, PutObjectLifecyclePolicyResponse> transformer = PutObjectLifecyclePolicyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getPutObjectLifecyclePolicyDetails(), retriedRequest);
                return (PutObjectLifecyclePolicyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ReencryptBucketResponse reencryptBucket(ReencryptBucketRequest request) {
        LOG.trace("Called reencryptBucket");
        ReencryptBucketRequest interceptedRequest = ReencryptBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReencryptBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ReencryptBucketResponse> transformer = ReencryptBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (ReencryptBucketResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RenameObjectResponse renameObject(RenameObjectRequest request) {
        LOG.trace("Called renameObject");
        RenameObjectRequest interceptedRequest = RenameObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RenameObjectConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RenameObjectResponse> transformer = RenameObjectConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getRenameObjectDetails(), retriedRequest);
                return (RenameObjectResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestoreObjectsResponse restoreObjects(RestoreObjectsRequest request) {
        LOG.trace("Called restoreObjects");
        RestoreObjectsRequest interceptedRequest = RestoreObjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreObjectsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreObjectsResponse> transformer = RestoreObjectsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getRestoreObjectsDetails(), retriedRequest);
                return (RestoreObjectsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBucketResponse updateBucket(UpdateBucketRequest request) {
        LOG.trace("Called updateBucket");
        UpdateBucketRequest interceptedRequest = UpdateBucketConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBucketConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBucketResponse> transformer = UpdateBucketConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getUpdateBucketDetails(), retriedRequest);
                return (UpdateBucketResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateNamespaceMetadataResponse updateNamespaceMetadata(UpdateNamespaceMetadataRequest request) {
        LOG.trace("Called updateNamespaceMetadata");
        UpdateNamespaceMetadataRequest interceptedRequest = UpdateNamespaceMetadataConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateNamespaceMetadataConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateNamespaceMetadataResponse> transformer = UpdateNamespaceMetadataConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateNamespaceMetadataDetails(), retriedRequest);
                return (UpdateNamespaceMetadataResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UploadPartResponse uploadPart(UploadPartRequest request) {
        LOG.trace("Called uploadPart");
        UploadPartRequest interceptedRequest = UploadPartConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UploadPartConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UploadPartResponse> transformer = UploadPartConverter.fromResponse();
        ib.property("x-obmcs-internal-signing-strategy-name", (Object)SigningStrategy.EXCLUDE_BODY);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUploadPartBody(), retriedRequest);
                return (UploadPartResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ObjectStorageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ObjectStoragePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ObjectStorageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ObjectStorageClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new ObjectStorageClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

