/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.model.BucketSummary;
import com.oracle.bmc.objectstorage.model.MultipartUpload;
import com.oracle.bmc.objectstorage.model.MultipartUploadPartSummary;
import com.oracle.bmc.objectstorage.model.ObjectSummary;
import com.oracle.bmc.objectstorage.model.PreauthenticatedRequestSummary;
import com.oracle.bmc.objectstorage.model.WorkRequestError;
import com.oracle.bmc.objectstorage.model.WorkRequestLogEntry;
import com.oracle.bmc.objectstorage.model.WorkRequestSummary;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ObjectStoragePaginators {
    private final ObjectStorage client;

    public Iterable<ListBucketsResponse> listBucketsResponseIterator(final ListBucketsRequest request) {
        return new ResponseIterable<ListBucketsRequest.Builder, ListBucketsRequest, ListBucketsResponse>(new Supplier<ListBucketsRequest.Builder>(){

            public ListBucketsRequest.Builder get() {
                return ListBucketsRequest.builder().copy(request);
            }
        }, new Function<ListBucketsResponse, String>(){

            public String apply(ListBucketsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListBucketsRequest.Builder>, ListBucketsRequest>(){

            public ListBucketsRequest apply(RequestBuilderAndToken<ListBucketsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListBucketsRequest, ListBucketsResponse>(){

            public ListBucketsResponse apply(ListBucketsRequest request) {
                return ObjectStoragePaginators.this.client.listBuckets(request);
            }
        });
    }

    public Iterable<BucketSummary> listBucketsRecordIterator(final ListBucketsRequest request) {
        return new ResponseRecordIterable<ListBucketsRequest.Builder, ListBucketsRequest, ListBucketsResponse, BucketSummary>(new Supplier<ListBucketsRequest.Builder>(){

            public ListBucketsRequest.Builder get() {
                return ListBucketsRequest.builder().copy(request);
            }
        }, new Function<ListBucketsResponse, String>(){

            public String apply(ListBucketsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListBucketsRequest.Builder>, ListBucketsRequest>(){

            public ListBucketsRequest apply(RequestBuilderAndToken<ListBucketsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListBucketsRequest, ListBucketsResponse>(){

            public ListBucketsResponse apply(ListBucketsRequest request) {
                return ObjectStoragePaginators.this.client.listBuckets(request);
            }
        }, new Function<ListBucketsResponse, List<BucketSummary>>(){

            public List<BucketSummary> apply(ListBucketsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMultipartUploadPartsResponse> listMultipartUploadPartsResponseIterator(final ListMultipartUploadPartsRequest request) {
        return new ResponseIterable<ListMultipartUploadPartsRequest.Builder, ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(new Supplier<ListMultipartUploadPartsRequest.Builder>(){

            public ListMultipartUploadPartsRequest.Builder get() {
                return ListMultipartUploadPartsRequest.builder().copy(request);
            }
        }, new Function<ListMultipartUploadPartsResponse, String>(){

            public String apply(ListMultipartUploadPartsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder>, ListMultipartUploadPartsRequest>(){

            public ListMultipartUploadPartsRequest apply(RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(){

            public ListMultipartUploadPartsResponse apply(ListMultipartUploadPartsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploadParts(request);
            }
        });
    }

    public Iterable<MultipartUploadPartSummary> listMultipartUploadPartsRecordIterator(final ListMultipartUploadPartsRequest request) {
        return new ResponseRecordIterable<ListMultipartUploadPartsRequest.Builder, ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse, MultipartUploadPartSummary>(new Supplier<ListMultipartUploadPartsRequest.Builder>(){

            public ListMultipartUploadPartsRequest.Builder get() {
                return ListMultipartUploadPartsRequest.builder().copy(request);
            }
        }, new Function<ListMultipartUploadPartsResponse, String>(){

            public String apply(ListMultipartUploadPartsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder>, ListMultipartUploadPartsRequest>(){

            public ListMultipartUploadPartsRequest apply(RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(){

            public ListMultipartUploadPartsResponse apply(ListMultipartUploadPartsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploadParts(request);
            }
        }, new Function<ListMultipartUploadPartsResponse, List<MultipartUploadPartSummary>>(){

            public List<MultipartUploadPartSummary> apply(ListMultipartUploadPartsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMultipartUploadsResponse> listMultipartUploadsResponseIterator(final ListMultipartUploadsRequest request) {
        return new ResponseIterable<ListMultipartUploadsRequest.Builder, ListMultipartUploadsRequest, ListMultipartUploadsResponse>(new Supplier<ListMultipartUploadsRequest.Builder>(){

            public ListMultipartUploadsRequest.Builder get() {
                return ListMultipartUploadsRequest.builder().copy(request);
            }
        }, new Function<ListMultipartUploadsResponse, String>(){

            public String apply(ListMultipartUploadsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMultipartUploadsRequest.Builder>, ListMultipartUploadsRequest>(){

            public ListMultipartUploadsRequest apply(RequestBuilderAndToken<ListMultipartUploadsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(){

            public ListMultipartUploadsResponse apply(ListMultipartUploadsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploads(request);
            }
        });
    }

    public Iterable<MultipartUpload> listMultipartUploadsRecordIterator(final ListMultipartUploadsRequest request) {
        return new ResponseRecordIterable<ListMultipartUploadsRequest.Builder, ListMultipartUploadsRequest, ListMultipartUploadsResponse, MultipartUpload>(new Supplier<ListMultipartUploadsRequest.Builder>(){

            public ListMultipartUploadsRequest.Builder get() {
                return ListMultipartUploadsRequest.builder().copy(request);
            }
        }, new Function<ListMultipartUploadsResponse, String>(){

            public String apply(ListMultipartUploadsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMultipartUploadsRequest.Builder>, ListMultipartUploadsRequest>(){

            public ListMultipartUploadsRequest apply(RequestBuilderAndToken<ListMultipartUploadsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(){

            public ListMultipartUploadsResponse apply(ListMultipartUploadsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploads(request);
            }
        }, new Function<ListMultipartUploadsResponse, List<MultipartUpload>>(){

            public List<MultipartUpload> apply(ListMultipartUploadsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListObjectsResponse> listObjectsResponseIterator(final ListObjectsRequest request) {
        return new ResponseIterable<ListObjectsRequest.Builder, ListObjectsRequest, ListObjectsResponse>(new Supplier<ListObjectsRequest.Builder>(){

            public ListObjectsRequest.Builder get() {
                return ListObjectsRequest.builder().copy(request);
            }
        }, new Function<ListObjectsResponse, String>(){

            public String apply(ListObjectsResponse response) {
                return response.getListObjects().getNextStartWith();
            }
        }, new Function<RequestBuilderAndToken<ListObjectsRequest.Builder>, ListObjectsRequest>(){

            public ListObjectsRequest apply(RequestBuilderAndToken<ListObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().start((String)input.getToken().orNull()).build();
            }
        }, new Function<ListObjectsRequest, ListObjectsResponse>(){

            public ListObjectsResponse apply(ListObjectsRequest request) {
                return ObjectStoragePaginators.this.client.listObjects(request);
            }
        });
    }

    public Iterable<ObjectSummary> listObjectsRecordIterator(final ListObjectsRequest request) {
        return new ResponseRecordIterable<ListObjectsRequest.Builder, ListObjectsRequest, ListObjectsResponse, ObjectSummary>(new Supplier<ListObjectsRequest.Builder>(){

            public ListObjectsRequest.Builder get() {
                return ListObjectsRequest.builder().copy(request);
            }
        }, new Function<ListObjectsResponse, String>(){

            public String apply(ListObjectsResponse response) {
                return response.getListObjects().getNextStartWith();
            }
        }, new Function<RequestBuilderAndToken<ListObjectsRequest.Builder>, ListObjectsRequest>(){

            public ListObjectsRequest apply(RequestBuilderAndToken<ListObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().start((String)input.getToken().orNull()).build();
            }
        }, new Function<ListObjectsRequest, ListObjectsResponse>(){

            public ListObjectsResponse apply(ListObjectsRequest request) {
                return ObjectStoragePaginators.this.client.listObjects(request);
            }
        }, new Function<ListObjectsResponse, List<ObjectSummary>>(){

            public List<ObjectSummary> apply(ListObjectsResponse response) {
                return response.getListObjects().getObjects();
            }
        });
    }

    public Iterable<ListPreauthenticatedRequestsResponse> listPreauthenticatedRequestsResponseIterator(final ListPreauthenticatedRequestsRequest request) {
        return new ResponseIterable<ListPreauthenticatedRequestsRequest.Builder, ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(new Supplier<ListPreauthenticatedRequestsRequest.Builder>(){

            public ListPreauthenticatedRequestsRequest.Builder get() {
                return ListPreauthenticatedRequestsRequest.builder().copy(request);
            }
        }, new Function<ListPreauthenticatedRequestsResponse, String>(){

            public String apply(ListPreauthenticatedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder>, ListPreauthenticatedRequestsRequest>(){

            public ListPreauthenticatedRequestsRequest apply(RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(){

            public ListPreauthenticatedRequestsResponse apply(ListPreauthenticatedRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listPreauthenticatedRequests(request);
            }
        });
    }

    public Iterable<PreauthenticatedRequestSummary> listPreauthenticatedRequestsRecordIterator(final ListPreauthenticatedRequestsRequest request) {
        return new ResponseRecordIterable<ListPreauthenticatedRequestsRequest.Builder, ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse, PreauthenticatedRequestSummary>(new Supplier<ListPreauthenticatedRequestsRequest.Builder>(){

            public ListPreauthenticatedRequestsRequest.Builder get() {
                return ListPreauthenticatedRequestsRequest.builder().copy(request);
            }
        }, new Function<ListPreauthenticatedRequestsResponse, String>(){

            public String apply(ListPreauthenticatedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder>, ListPreauthenticatedRequestsRequest>(){

            public ListPreauthenticatedRequestsRequest apply(RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(){

            public ListPreauthenticatedRequestsResponse apply(ListPreauthenticatedRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listPreauthenticatedRequests(request);
            }
        }, new Function<ListPreauthenticatedRequestsResponse, List<PreauthenticatedRequestSummary>>(){

            public List<PreauthenticatedRequestSummary> apply(ListPreauthenticatedRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable<ListWorkRequestErrorsRequest.Builder, ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestErrorsRequest.Builder, ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse, WorkRequestError>(new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestErrors(request);
            }
        }, new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable<ListWorkRequestLogsRequest.Builder, ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestLogsRequest.Builder, ListWorkRequestLogsRequest, ListWorkRequestLogsResponse, WorkRequestLogEntry>(new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestLogs(request);
            }
        }, new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable<ListWorkRequestsRequest.Builder, ListWorkRequestsRequest, ListWorkRequestsResponse, WorkRequestSummary>(new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequests(request);
            }
        }, new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ObjectStoragePaginators(ObjectStorage client) {
        this.client = client;
    }
}

