/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.model.Bucket;
import com.oracle.bmc.objectstorage.requests.CreateBucketRequest;
import com.oracle.bmc.objectstorage.responses.CreateBucketResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBucketConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateBucketConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateBucketRequest interceptRequest(CreateBucketRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateBucketRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateBucketDetails(), (String)"createBucketDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment(request.getNamespaceName())).path("b");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, CreateBucketResponse> fromResponse() {
        Function<Response, CreateBucketResponse> transformer = new Function<Response, CreateBucketResponse>(){

            public CreateBucketResponse apply(Response rawResponse) {
                Optional<List<String>> locationHeader;
                Optional<List<String>> eTagHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for CreateBucketResponse");
                Function<Response, WithHeaders<Bucket>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Bucket.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                CreateBucketResponse.Builder builder = CreateBucketResponse.builder();
                builder.bucket((Bucket)response.getItem());
                Optional<List<String>> opcClientRequestIdHeader = HeaderUtils.get(headers, "opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId(HeaderUtils.toValue("opc-client-request-id", (String)((List)opcClientRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((eTagHeader = HeaderUtils.get(headers, "ETag")).isPresent()) {
                    builder.eTag(HeaderUtils.toValue("ETag", (String)((List)eTagHeader.get()).get(0), String.class));
                }
                if ((locationHeader = HeaderUtils.get(headers, "Location")).isPresent()) {
                    builder.location(HeaderUtils.toValue("Location", (String)((List)locationHeader.get()).get(0), String.class));
                }
                CreateBucketResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

