/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.model.Range;
import com.oracle.bmc.objectstorage.internal.http.ObjectMetadataInterceptor;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetObjectConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetObjectConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetObjectRequest interceptRequest(GetObjectRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetObjectRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment(request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment(request.getBucketName())).path("o").path(HttpUtils.encodePathSegment(request.getObjectName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getIfNoneMatch() != null) {
            ib.header("if-none-match", request.getIfNoneMatch());
        }
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", request.getOpcClientRequestId());
        }
        if (request.getRange() != null) {
            ib.header("range", request.getRange());
        }
        return ib;
    }

    public static Function<Response, GetObjectResponse> fromResponse() {
        Function<Response, GetObjectResponse> transformer = new Function<Response, GetObjectResponse>(){

            public GetObjectResponse apply(Response rawResponse) {
                Optional<List<String>> timeOfArchivalHeader;
                Optional<List<String>> archivalStateHeader;
                Optional<List<String>> lastModifiedHeader;
                Optional<List<String>> contentEncodingHeader;
                Optional<List<String>> contentLanguageHeader;
                Optional<List<String>> contentTypeHeader;
                Optional<List<String>> opcMultipartMd5Header;
                Optional<List<String>> contentMd5Header;
                Optional<List<String>> contentRangeHeader;
                Optional<List<String>> eTagHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetObjectResponse");
                Function<Response, WithHeaders<InputStream>> responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetObjectResponse.Builder builder = GetObjectResponse.builder();
                if (response.getStatusCode() != 304) {
                    builder.inputStream((InputStream)response.getItem());
                    builder.isNotModified(false);
                } else {
                    builder.isNotModified(true);
                }
                Optional<List<String>> opcClientRequestIdHeader = HeaderUtils.get(headers, "opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId(HeaderUtils.toValue("opc-client-request-id", (String)((List)opcClientRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((eTagHeader = HeaderUtils.get(headers, "ETag")).isPresent()) {
                    builder.eTag(HeaderUtils.toValue("ETag", (String)((List)eTagHeader.get()).get(0), String.class));
                }
                HashMap<String, String> opcMeta = new HashMap<String, String>();
                String opcMetaPattern = "opc-meta-".toLowerCase(Locale.ROOT);
                for (Map.Entry header : headers.entrySet()) {
                    if (!((String)header.getKey()).toLowerCase(Locale.ROOT).startsWith(opcMetaPattern)) continue;
                    opcMeta.put((String)header.getKey(), (String)((List)header.getValue()).get(0));
                }
                builder.opcMeta(opcMeta);
                Optional<List<String>> contentLengthHeader = HeaderUtils.get(headers, "content-length");
                if (contentLengthHeader.isPresent()) {
                    builder.contentLength(HeaderUtils.toValue("content-length", (String)((List)contentLengthHeader.get()).get(0), Long.class));
                }
                if ((contentRangeHeader = HeaderUtils.get(headers, "content-range")).isPresent()) {
                    builder.contentRange(HeaderUtils.toValue("content-range", (String)((List)contentRangeHeader.get()).get(0), Range.class));
                }
                if ((contentMd5Header = HeaderUtils.get(headers, "content-md5")).isPresent()) {
                    builder.contentMd5(HeaderUtils.toValue("content-md5", (String)((List)contentMd5Header.get()).get(0), String.class));
                }
                if ((opcMultipartMd5Header = HeaderUtils.get(headers, "opc-multipart-md5")).isPresent()) {
                    builder.opcMultipartMd5(HeaderUtils.toValue("opc-multipart-md5", (String)((List)opcMultipartMd5Header.get()).get(0), String.class));
                }
                if ((contentTypeHeader = HeaderUtils.get(headers, "content-type")).isPresent()) {
                    builder.contentType(HeaderUtils.toValue("content-type", (String)((List)contentTypeHeader.get()).get(0), String.class));
                }
                if ((contentLanguageHeader = HeaderUtils.get(headers, "content-language")).isPresent()) {
                    builder.contentLanguage(HeaderUtils.toValue("content-language", (String)((List)contentLanguageHeader.get()).get(0), String.class));
                }
                if ((contentEncodingHeader = HeaderUtils.get(headers, "content-encoding")).isPresent()) {
                    builder.contentEncoding(HeaderUtils.toValue("content-encoding", (String)((List)contentEncodingHeader.get()).get(0), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get(headers, "last-modified")).isPresent()) {
                    builder.lastModified(HeaderUtils.toValue("last-modified", (String)((List)lastModifiedHeader.get()).get(0), Date.class));
                }
                if ((archivalStateHeader = HeaderUtils.get(headers, "archival-state")).isPresent()) {
                    builder.archivalState(HeaderUtils.toValue("archival-state", (String)((List)archivalStateHeader.get()).get(0), String.class));
                }
                if ((timeOfArchivalHeader = HeaderUtils.get(headers, "time-of-archival")).isPresent()) {
                    builder.timeOfArchival(HeaderUtils.toValue("time-of-archival", (String)((List)timeOfArchivalHeader.get()).get(0), Date.class));
                }
                GetObjectResponse responseWrapper = builder.build();
                responseWrapper = ObjectMetadataInterceptor.intercept(responseWrapper);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

