/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.model.WorkRequest;
import com.oracle.bmc.objectstorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.objectstorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetWorkRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetWorkRequestConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetWorkRequestRequest interceptRequest(GetWorkRequestRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetWorkRequestRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("workRequests").path(HttpUtils.encodePathSegment(request.getWorkRequestId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, GetWorkRequestResponse> fromResponse() {
        Function<Response, GetWorkRequestResponse> transformer = new Function<Response, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(Response rawResponse) {
                Optional<List<String>> retryAfterHeader;
                Optional<List<String>> opcClientRequestIdHeader;
                LOG.trace("Transform function invoked for GetWorkRequestResponse");
                Function<Response, WithHeaders<WorkRequest>> responseFn = RESPONSE_CONVERSION_FACTORY.create(WorkRequest.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetWorkRequestResponse.Builder builder = GetWorkRequestResponse.builder();
                builder.workRequest((WorkRequest)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcClientRequestIdHeader = HeaderUtils.get(headers, "opc-client-request-id")).isPresent()) {
                    builder.opcClientRequestId(HeaderUtils.toValue("opc-client-request-id", (String)((List)opcClientRequestIdHeader.get()).get(0), String.class));
                }
                if ((retryAfterHeader = HeaderUtils.get(headers, "retry-after")).isPresent()) {
                    builder.retryAfter(HeaderUtils.toValue("retry-after", (String)((List)retryAfterHeader.get()).get(0), Float.class));
                }
                GetWorkRequestResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

