/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.model.ListObjects;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListObjectsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListObjectsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListObjectsRequest interceptRequest(ListObjectsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListObjectsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment(request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment(request.getBucketName())).path("o");
        if (request.getPrefix() != null) {
            target = target.queryParam("prefix", HttpUtils.attemptEncodeQueryParam(request.getPrefix()));
        }
        if (request.getStart() != null) {
            target = target.queryParam("start", HttpUtils.attemptEncodeQueryParam(request.getStart()));
        }
        if (request.getEnd() != null) {
            target = target.queryParam("end", HttpUtils.attemptEncodeQueryParam(request.getEnd()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getDelimiter() != null) {
            target = target.queryParam("delimiter", HttpUtils.attemptEncodeQueryParam(request.getDelimiter()));
        }
        if (request.getFields() != null) {
            target = target.queryParam("fields", HttpUtils.attemptEncodeQueryParam(request.getFields()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, ListObjectsResponse> fromResponse() {
        Function<Response, ListObjectsResponse> transformer = new Function<Response, ListObjectsResponse>(){

            public ListObjectsResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ListObjectsResponse");
                Function<Response, WithHeaders<ListObjects>> responseFn = RESPONSE_CONVERSION_FACTORY.create(ListObjects.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListObjectsResponse.Builder builder = ListObjectsResponse.builder();
                builder.listObjects((ListObjects)response.getItem());
                Optional<List<String>> opcClientRequestIdHeader = HeaderUtils.get(headers, "opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId(HeaderUtils.toValue("opc-client-request-id", (String)((List)opcClientRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                ListObjectsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

