/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.model.PreauthenticatedRequestSummary;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListPreauthenticatedRequestsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListPreauthenticatedRequestsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListPreauthenticatedRequestsRequest interceptRequest(ListPreauthenticatedRequestsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListPreauthenticatedRequestsRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment(request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment(request.getBucketName())).path("p");
        if (request.getObjectNamePrefix() != null) {
            target = target.queryParam("objectNamePrefix", HttpUtils.attemptEncodeQueryParam(request.getObjectNamePrefix()));
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", HttpUtils.attemptEncodeQueryParam(request.getLimit()));
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", HttpUtils.attemptEncodeQueryParam(request.getPage()));
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", request.getOpcClientRequestId());
        }
        return ib;
    }

    public static Function<Response, ListPreauthenticatedRequestsResponse> fromResponse() {
        Function<Response, ListPreauthenticatedRequestsResponse> transformer = new Function<Response, ListPreauthenticatedRequestsResponse>(){

            public ListPreauthenticatedRequestsResponse apply(Response rawResponse) {
                Optional<List<String>> opcNextPageHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for ListPreauthenticatedRequestsResponse");
                Function<Response, WithHeaders<List<PreauthenticatedRequestSummary>>> responseFn = RESPONSE_CONVERSION_FACTORY.create(new GenericType<List<PreauthenticatedRequestSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                ListPreauthenticatedRequestsResponse.Builder builder = ListPreauthenticatedRequestsResponse.builder();
                builder.items((List)response.getItem());
                Optional<List<String>> opcClientRequestIdHeader = HeaderUtils.get(headers, "opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId(HeaderUtils.toValue("opc-client-request-id", (String)((List)opcClientRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get(headers, "opc-next-page")).isPresent()) {
                    builder.opcNextPage(HeaderUtils.toValue("opc-next-page", (String)((List)opcNextPageHeader.get()).get(0), String.class));
                }
                ListPreauthenticatedRequestsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

