/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.objectstorage.internal.http.ObjectMetadataInterceptor;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutObjectConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PutObjectConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static PutObjectRequest interceptRequest(PutObjectRequest request) {
        request = ObjectMetadataInterceptor.intercept(request);
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, PutObjectRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getPutObjectBody(), (String)"putObjectBody is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("n").path(HttpUtils.encodePathSegment(request.getNamespaceName())).path("b").path(HttpUtils.encodePathSegment(request.getBucketName())).path("o").path(HttpUtils.encodePathSegment(request.getObjectName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getIfMatch() != null) {
            ib.header("if-match", request.getIfMatch());
        }
        if (request.getIfNoneMatch() != null) {
            ib.header("if-none-match", request.getIfNoneMatch());
        }
        if (request.getOpcClientRequestId() != null) {
            ib.header("opc-client-request-id", request.getOpcClientRequestId());
        }
        if (request.getExpect() != null) {
            ib.header("Expect", request.getExpect());
        }
        if (request.getContentLength() != null) {
            ib.header("Content-Length", request.getContentLength());
        }
        if (request.getContentMD5() != null) {
            ib.header("Content-MD5", request.getContentMD5());
        }
        if (request.getContentType() != null) {
            ib.header("Content-Type", request.getContentType());
        }
        if (request.getContentLanguage() != null) {
            ib.header("Content-Language", request.getContentLanguage());
        }
        if (request.getContentEncoding() != null) {
            ib.header("Content-Encoding", request.getContentEncoding());
        }
        if (request.getOpcMeta() != null) {
            for (Map.Entry<String, String> header : request.getOpcMeta().entrySet()) {
                ib.header(header.getKey(), header.getValue());
            }
        }
        return ib;
    }

    public static Function<Response, PutObjectResponse> fromResponse() {
        Function<Response, PutObjectResponse> transformer = new Function<Response, PutObjectResponse>(){

            public PutObjectResponse apply(Response rawResponse) {
                Optional<List<String>> lastModifiedHeader;
                Optional<List<String>> eTagHeader;
                Optional<List<String>> opcContentMd5Header;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for PutObjectResponse");
                Function<Response, WithHeaders<Void>> responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                PutObjectResponse.Builder builder = PutObjectResponse.builder();
                Optional<List<String>> opcClientRequestIdHeader = HeaderUtils.get(headers, "opc-client-request-id");
                if (opcClientRequestIdHeader.isPresent()) {
                    builder.opcClientRequestId(HeaderUtils.toValue("opc-client-request-id", (String)((List)opcClientRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((opcContentMd5Header = HeaderUtils.get(headers, "opc-content-md5")).isPresent()) {
                    builder.opcContentMd5(HeaderUtils.toValue("opc-content-md5", (String)((List)opcContentMd5Header.get()).get(0), String.class));
                }
                if ((eTagHeader = HeaderUtils.get(headers, "ETag")).isPresent()) {
                    builder.eTag(HeaderUtils.toValue("ETag", (String)((List)eTagHeader.get()).get(0), String.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get(headers, "last-modified")).isPresent()) {
                    builder.lastModified(HeaderUtils.toValue("last-modified", (String)((List)lastModifiedHeader.get()).get(0), Date.class));
                }
                PutObjectResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

