/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AbortMultipartUploadRequest
extends BmcRequest {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private String uploadId;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "bucketName", "objectName", "uploadId", "opcClientRequestId"})
    AbortMultipartUploadRequest(String namespaceName, String bucketName, String objectName, String uploadId, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.uploadId = uploadId;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String namespaceName;
        private String bucketName;
        private String objectName;
        private String uploadId;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AbortMultipartUploadRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.uploadId(o.getUploadId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AbortMultipartUploadRequest build() {
            AbortMultipartUploadRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public AbortMultipartUploadRequest buildWithoutInvocationCallback() {
            return new AbortMultipartUploadRequest(this.namespaceName, this.bucketName, this.objectName, this.uploadId, this.opcClientRequestId);
        }

        public String toString() {
            return "AbortMultipartUploadRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", objectName=" + this.objectName + ", uploadId=" + this.uploadId + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

