/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CancelWorkRequestRequest
extends BmcRequest {
    private String workRequestId;
    private String opcClientRequestId;

    @ConstructorProperties(value={"workRequestId", "opcClientRequestId"})
    CancelWorkRequestRequest(String workRequestId, String opcClientRequestId) {
        this.workRequestId = workRequestId;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String workRequestId;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelWorkRequestRequest build() {
            CancelWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public CancelWorkRequestRequest buildWithoutInvocationCallback() {
            return new CancelWorkRequestRequest(this.workRequestId, this.opcClientRequestId);
        }

        public String toString() {
            return "CancelWorkRequestRequest.Builder(workRequestId=" + this.workRequestId + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

