/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.objectstorage.model.CopyObjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CopyObjectRequest
extends BmcRequest {
    private String namespaceName;
    private String bucketName;
    private CopyObjectDetails copyObjectDetails;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "bucketName", "copyObjectDetails", "opcClientRequestId"})
    CopyObjectRequest(String namespaceName, String bucketName, CopyObjectDetails copyObjectDetails, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.copyObjectDetails = copyObjectDetails;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public CopyObjectDetails getCopyObjectDetails() {
        return this.copyObjectDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String namespaceName;
        private String bucketName;
        private CopyObjectDetails copyObjectDetails;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CopyObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.copyObjectDetails(o.getCopyObjectDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CopyObjectRequest build() {
            CopyObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder copyObjectDetails(CopyObjectDetails copyObjectDetails) {
            this.copyObjectDetails = copyObjectDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public CopyObjectRequest buildWithoutInvocationCallback() {
            return new CopyObjectRequest(this.namespaceName, this.bucketName, this.copyObjectDetails, this.opcClientRequestId);
        }

        public String toString() {
            return "CopyObjectRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", copyObjectDetails=" + this.copyObjectDetails + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

