/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.objectstorage.model.CreateBucketDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CreateBucketRequest
extends BmcRequest {
    private String namespaceName;
    private CreateBucketDetails createBucketDetails;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "createBucketDetails", "opcClientRequestId"})
    CreateBucketRequest(String namespaceName, CreateBucketDetails createBucketDetails, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.createBucketDetails = createBucketDetails;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CreateBucketDetails getCreateBucketDetails() {
        return this.createBucketDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String namespaceName;
        private CreateBucketDetails createBucketDetails;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateBucketRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.createBucketDetails(o.getCreateBucketDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateBucketRequest build() {
            CreateBucketRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder createBucketDetails(CreateBucketDetails createBucketDetails) {
            this.createBucketDetails = createBucketDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public CreateBucketRequest buildWithoutInvocationCallback() {
            return new CreateBucketRequest(this.namespaceName, this.createBucketDetails, this.opcClientRequestId);
        }

        public String toString() {
            return "CreateBucketRequest.Builder(namespaceName=" + this.namespaceName + ", createBucketDetails=" + this.createBucketDetails + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

