/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteObjectLifecyclePolicyRequest
extends BmcRequest {
    private String namespaceName;
    private String bucketName;
    private String opcClientRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"namespaceName", "bucketName", "opcClientRequestId", "ifMatch"})
    DeleteObjectLifecyclePolicyRequest(String namespaceName, String bucketName, String opcClientRequestId, String ifMatch) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.opcClientRequestId = opcClientRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String namespaceName;
        private String bucketName;
        private String opcClientRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteObjectLifecyclePolicyRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteObjectLifecyclePolicyRequest build() {
            DeleteObjectLifecyclePolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteObjectLifecyclePolicyRequest buildWithoutInvocationCallback() {
            return new DeleteObjectLifecyclePolicyRequest(this.namespaceName, this.bucketName, this.opcClientRequestId, this.ifMatch);
        }

        public String toString() {
            return "DeleteObjectLifecyclePolicyRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", opcClientRequestId=" + this.opcClientRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

