/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetNamespaceMetadataRequest
extends BmcRequest {
    private String namespaceName;
    private String opcClientRequestId;

    @ConstructorProperties(value={"namespaceName", "opcClientRequestId"})
    GetNamespaceMetadataRequest(String namespaceName, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder {
        private String namespaceName;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNamespaceMetadataRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNamespaceMetadataRequest build() {
            GetNamespaceMetadataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public GetNamespaceMetadataRequest buildWithoutInvocationCallback() {
            return new GetNamespaceMetadataRequest(this.namespaceName, this.opcClientRequestId);
        }

        public String toString() {
            return "GetNamespaceMetadataRequest.Builder(namespaceName=" + this.namespaceName + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

