/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetNamespaceRequest
extends BmcRequest {
    private String opcClientRequestId;
    private String compartmentId;

    @ConstructorProperties(value={"opcClientRequestId", "compartmentId"})
    GetNamespaceRequest(String opcClientRequestId, String compartmentId) {
        this.opcClientRequestId = opcClientRequestId;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder {
        private String opcClientRequestId;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetNamespaceRequest o) {
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetNamespaceRequest build() {
            GetNamespaceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public GetNamespaceRequest buildWithoutInvocationCallback() {
            return new GetNamespaceRequest(this.opcClientRequestId, this.compartmentId);
        }

        public String toString() {
            return "GetNamespaceRequest.Builder(opcClientRequestId=" + this.opcClientRequestId + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

